/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;

public class StringEscaper
implements Cloneable {
    private ArrayList translationVector = new ArrayList();
    private String[] translationTable;
    public static StringEscaper xmlEscaper;
    public static StringEscaper xmlNumericEscaper;
    public static StringEscaper htmlEscaper;
    public static StringEscaper urlArgEscaper;
    public static StringEscaper urlEscaper;

    public void defineEscape(char from, String to) {
        char i = from;
        if (i >= this.translationVector.size()) {
            final int count = i + '\u0001' - this.translationVector.size();
            this.translationVector.addAll(new AbstractList(){

                public Object get(int index) {
                    return null;
                }

                public int size() {
                    return count;
                }
            });
        }
        this.translationVector.set(i, to);
    }

    public void makeImmutable() {
        this.translationTable = this.translationVector.toArray(new String[this.translationVector.size()]);
        this.translationVector = null;
    }

    public String escapeString(String s) {
        StringBuffer sb = null;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            String escape = c > '\u007f' ? "&#" + Integer.toString(c) + ";" : (c >= this.translationTable.length ? null : this.translationTable[c]);
            if (escape == null) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer(n * 2);
                sb.append(s.substring(0, i));
            }
            sb.append(escape);
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public void appendEscapedString(String s, StringBuffer sb) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            String escape = c >= this.translationTable.length ? null : this.translationTable[c];
            if (escape == null) {
                sb.append(c);
                continue;
            }
            sb.append(escape);
        }
    }

    protected Object clone() {
        StringEscaper clone = new StringEscaper();
        if (this.translationVector != null) {
            clone.translationVector = new ArrayList(this.translationVector);
        }
        if (this.translationTable != null) {
            clone.translationTable = (String[])this.translationTable.clone();
        }
        return clone;
    }

    public StringEscaper getMutableClone() {
        StringEscaper clone = (StringEscaper)this.clone();
        if (clone.translationVector == null) {
            clone.translationVector = new ArrayList<String>(Arrays.asList(clone.translationTable));
            clone.translationTable = null;
        }
        return clone;
    }

    static {
        htmlEscaper = new StringEscaper();
        htmlEscaper.defineEscape('&', "&amp;");
        htmlEscaper.defineEscape('\"', "&quot;");
        htmlEscaper.defineEscape('\'', "&#39;");
        htmlEscaper.defineEscape('<', "&lt;");
        htmlEscaper.defineEscape('>', "&gt;");
        xmlNumericEscaper = new StringEscaper();
        xmlNumericEscaper.defineEscape('&', "&#38;");
        xmlNumericEscaper.defineEscape('\"', "&#34;");
        xmlNumericEscaper.defineEscape('\'', "&#39;");
        xmlNumericEscaper.defineEscape('<', "&#60;");
        xmlNumericEscaper.defineEscape('>', "&#62;");
        urlArgEscaper = new StringEscaper();
        urlArgEscaper.defineEscape('?', "%3f");
        urlArgEscaper.defineEscape('&', "%26");
        urlEscaper = urlArgEscaper.getMutableClone();
        urlEscaper.defineEscape('%', "%%");
        urlEscaper.defineEscape('\"', "%22");
        urlEscaper.defineEscape('\r', "+");
        urlEscaper.defineEscape('\n', "+");
        urlEscaper.defineEscape(' ', "+");
        urlEscaper.defineEscape('#', "%23");
        htmlEscaper.makeImmutable();
        xmlEscaper = htmlEscaper;
        xmlNumericEscaper.makeImmutable();
        urlArgEscaper.makeImmutable();
        urlEscaper.makeImmutable();
    }
}

