/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.dialect.AbstractDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class OracleDatabaseDialect
extends AbstractDatabaseDialect {
    private static final long serialVersionUID = -3869260264366995990L;
    private static final IDatabaseType DBTYPE = new DatabaseType("Oracle", "ORACLE", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.ODBC, DatabaseAccessType.OCI, DatabaseAccessType.JNDI), 1521, "http://download.oracle.com/docs/cd/B19306_01/java.102/b14355/urls.htm#i1006362");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getNativeDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public boolean supportsAutoInc() {
        return false;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT /*+FIRST_ROWS*/ * FROM " + tableName + " WHERE ROWNUM < 1";
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT /*+FIRST_ROWS*/ " + columnname + " FROM " + tableName + " WHERE ROWNUM < 1";
    }

    @Override
    public boolean needsToLockAllTables() {
        return false;
    }

    @Override
    public String getURL(IDatabaseConnection databaseConnection) throws DatabaseDialectException {
        String databaseName = databaseConnection.getDatabaseName();
        String port = databaseConnection.getDatabasePort();
        String hostname = databaseConnection.getHostname();
        if (databaseConnection.getAccessType() == DatabaseAccessType.ODBC) {
            return "jdbc:odbc:" + databaseName;
        }
        if (databaseConnection.getAccessType() == DatabaseAccessType.NATIVE) {
            if (databaseName != null && databaseName.length() > 0 && (databaseName.startsWith("/") || databaseName.startsWith(":"))) {
                return this.getNativeJdbcPre() + hostname + ":" + port + databaseName;
            }
            if (OracleDatabaseDialect.isEmpty(port) || port.equals("-1") || port.equals("0")) {
                return this.getNativeJdbcPre() + databaseName;
            }
            return this.getNativeJdbcPre() + hostname + ":" + port + ":" + databaseName;
        }
        if (databaseName != null && databaseName.length() > 0) {
            if (hostname != null && hostname.length() > 0 && port != null && port.length() > 0) {
                return "jdbc:oracle:oci:@(description=(address=(host=" + hostname + ")(protocol=tcp)(port=" + port + "))(connect_data=(sid=" + databaseName + ")))";
            }
            return "jdbc:oracle:oci:@" + databaseName;
        }
        throw new DatabaseDialectException("Unable to construct a JDBC URL: at least the database name must be specified");
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:oracle:thin:@";
    }

    @Override
    public boolean supportsOptionsInURL() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        return "SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName.toUpperCase() + "'";
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".currval FROM DUAL";
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".nextval FROM dual";
    }

    @Override
    public boolean useSchemaNameForTableList() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public String getAddColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD ( " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " ) ";
    }

    @Override
    public String getDropColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP ( " + v.getName() + " ) " + " ";
    }

    @Override
    public String getModifyColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        IValueMeta tmpColumn = v.clone();
        int threeoh = v.getName().length() >= 30 ? 30 : v.getName().length();
        tmpColumn.setName(v.getName().substring(0, threeoh) + "_KTL");
        String sql = "";
        sql = sql + this.getAddColumnStatement(tablename, tmpColumn, tk, use_autoinc, pk, semicolon) + ";" + " ";
        sql = sql + "UPDATE " + tablename + " SET " + tmpColumn.getName() + "=" + v.getName() + ";" + " ";
        sql = sql + this.getDropColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon) + ";" + " ";
        sql = sql + this.getAddColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon) + ";" + " ";
        sql = sql + "UPDATE " + tablename + " SET " + v.getName() + "=" + tmpColumn.getName() + ";" + " ";
        sql = sql + this.getDropColumnStatement(tablename, tmpColumn, tk, use_autoinc, pk, semicolon);
        return sql;
    }

    @Override
    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        StringBuffer retval = new StringBuffer(128);
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval.append("DATE");
                break;
            }
            case 4: {
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 6: {
                retval.append("NUMBER");
                if (length <= 0) break;
                retval.append('(').append(length);
                if (precision > 0) {
                    retval.append(", ").append(precision);
                }
                retval.append(')');
                break;
            }
            case 5: {
                retval.append("INTEGER");
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval.append("CLOB");
                    break;
                }
                if (length == 1) {
                    retval.append("CHAR(1)");
                    break;
                }
                if (length > 0 && length <= 2000) {
                    retval.append("VARCHAR2(").append(length).append(')');
                    break;
                }
                if (length <= 0) {
                    retval.append("VARCHAR2(2000)");
                    break;
                }
                retval.append("CLOB");
                break;
            }
            case 8: {
                retval.append("BLOB");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (add_cr) {
            retval.append(" ");
        }
        return retval.toString();
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    }

    @Override
    public String getSQLListOfProcedures(IDatabaseConnection connection) {
        return "SELECT DISTINCT DECODE(package_name, NULL, '', package_name||'.')||object_name FROM user_arguments";
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        StringBuffer sql = new StringBuffer(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("LOCK TABLE ").append(tableNames[i]).append(" IN EXCLUSIVE MODE;").append(" ");
        }
        return sql.toString();
    }

    @Override
    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"ojdbc14.jar", "orai18n.jar"};
    }

    @Override
    public IDatabaseConnection createNativeConnection(String jdbcUrl) {
        if (!jdbcUrl.startsWith(this.getNativeJdbcPre())) {
            throw new RuntimeException("JDBC URL " + jdbcUrl + " does not start with " + this.getNativeJdbcPre());
        }
        DatabaseConnection dbconn = new DatabaseConnection();
        dbconn.setDatabaseType(this.getDatabaseType());
        dbconn.setAccessType(DatabaseAccessType.NATIVE);
        String str = jdbcUrl.substring(this.getNativeJdbcPre().length());
        String hostname = null;
        String port = null;
        String databaseName = null;
        if (str.indexOf(":") >= 0) {
            hostname = str.substring(0, str.indexOf(":"));
            if ((str = str.substring(str.indexOf(":") + 1)).indexOf(":") >= 0) {
                port = str.substring(0, str.indexOf(":"));
                databaseName = str.substring(str.indexOf(":") + 1);
            } else {
                port = str;
            }
        } else {
            databaseName = str;
        }
        if (hostname != null) {
            dbconn.setHostname(hostname);
        }
        if (port != null) {
            dbconn.setDatabasePort(port);
        }
        if (databaseName != null) {
            dbconn.setDatabaseName(databaseName);
        }
        return dbconn;
    }
}

