/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.pgbulkloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

@PluginDialog(id="PGBulkLoader", image="BLKPG.svg", pluginType=PluginDialog.PluginType.STEP, documentationUrl="http://wiki.pentaho.com/display/EAI/PostgreSQL+Bulk+Loader")
public class PGBulkLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = PGBulkLoaderMeta.class;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlLoadAction;
    private CCombo wLoadAction;
    private FormData fdlLoadAction;
    private FormData fdLoadAction;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Label wlEnclosure;
    private TextVar wEnclosure;
    private FormData fdlEnclosure;
    private FormData fdEnclosure;
    private Label wlDelimiter;
    private TextVar wDelimiter;
    private FormData fdlDelimiter;
    private FormData fdDelimiter;
    private Label wlDbNameOverride;
    private TextVar wDbNameOverride;
    private FormData fdlDbNameOverride;
    private FormData fdDbNameOverride;
    private Button wGetLU;
    private FormData fdGetLU;
    private Listener lsGetLU;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private Label wlStopOnError;
    private Button wStopOnError;
    private FormData fdlStopOnError;
    private FormData fdStopOnError;
    private PGBulkLoaderMeta input;
    private static final String[] ALL_FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Filetype.All", (String[])new String[0])};
    private ColumnInfo[] ciReturn;
    private Map<String, Integer> inputFields;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public PGBulkLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (PGBulkLoaderMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PGBulkLoaderDialog.this.input.setChanged();
            }
        };
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                PGBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData((Object)this.fdTable);
        this.wlLoadAction = new Label((Composite)this.shell, 131072);
        this.wlLoadAction.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.LoadAction.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLoadAction);
        this.fdlLoadAction = new FormData();
        this.fdlLoadAction.left = new FormAttachment(0, 0);
        this.fdlLoadAction.right = new FormAttachment(middle, -margin);
        this.fdlLoadAction.top = new FormAttachment((Control)this.wTable, margin);
        this.wlLoadAction.setLayoutData((Object)this.fdlLoadAction);
        this.wLoadAction = new CCombo((Composite)this.shell, 2060);
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.select(0);
        this.wLoadAction.addModifyListener(lsMod);
        this.props.setLook((Control)this.wLoadAction);
        this.fdLoadAction = new FormData();
        this.fdLoadAction.left = new FormAttachment(middle, 0);
        this.fdLoadAction.top = new FormAttachment((Control)this.wTable, margin);
        this.fdLoadAction.right = new FormAttachment(100, 0);
        this.wLoadAction.setLayoutData((Object)this.fdLoadAction);
        this.fdLoadAction = new FormData();
        this.fdLoadAction.left = new FormAttachment(middle, 0);
        this.fdLoadAction.top = new FormAttachment((Control)this.wTable, margin);
        this.fdLoadAction.right = new FormAttachment(100, 0);
        this.wLoadAction.setLayoutData((Object)this.fdLoadAction);
        this.wlDbNameOverride = new Label((Composite)this.shell, 131072);
        this.wlDbNameOverride.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DbNameOverride.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDbNameOverride);
        this.fdlDbNameOverride = new FormData();
        this.fdlDbNameOverride.left = new FormAttachment(0, 0);
        this.fdlDbNameOverride.top = new FormAttachment((Control)this.wLoadAction, margin);
        this.fdlDbNameOverride.right = new FormAttachment(middle, -margin);
        this.wlDbNameOverride.setLayoutData((Object)this.fdlDbNameOverride);
        this.wDbNameOverride = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDbNameOverride);
        this.wDbNameOverride.addModifyListener(lsMod);
        this.fdDbNameOverride = new FormData();
        this.fdDbNameOverride.left = new FormAttachment(middle, 0);
        this.fdDbNameOverride.top = new FormAttachment((Control)this.wLoadAction, margin);
        this.fdDbNameOverride.right = new FormAttachment(100, 0);
        this.wDbNameOverride.setLayoutData((Object)this.fdDbNameOverride);
        this.wlEnclosure = new Label((Composite)this.shell, 131072);
        this.wlEnclosure.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Enclosure.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEnclosure);
        this.fdlEnclosure = new FormData();
        this.fdlEnclosure.left = new FormAttachment(0, 0);
        this.fdlEnclosure.top = new FormAttachment((Control)this.wDbNameOverride, margin);
        this.fdlEnclosure.right = new FormAttachment(middle, -margin);
        this.wlEnclosure.setLayoutData((Object)this.fdlEnclosure);
        this.wEnclosure = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        this.fdEnclosure = new FormData();
        this.fdEnclosure.left = new FormAttachment(middle, 0);
        this.fdEnclosure.top = new FormAttachment((Control)this.wDbNameOverride, margin);
        this.fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)this.fdEnclosure);
        this.wlDelimiter = new Label((Composite)this.shell, 131072);
        this.wlDelimiter.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Delimiter.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDelimiter);
        this.fdlDelimiter = new FormData();
        this.fdlDelimiter.left = new FormAttachment(0, 0);
        this.fdlDelimiter.top = new FormAttachment((Control)this.wEnclosure, margin);
        this.fdlDelimiter.right = new FormAttachment(middle, -margin);
        this.wlDelimiter.setLayoutData((Object)this.fdlDelimiter);
        this.wDelimiter = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        this.fdDelimiter = new FormData();
        this.fdDelimiter.left = new FormAttachment(middle, 0);
        this.fdDelimiter.top = new FormAttachment((Control)this.wEnclosure, margin);
        this.fdDelimiter.right = new FormAttachment(100, 0);
        this.wDelimiter.setLayoutData((Object)this.fdDelimiter);
        this.wlStopOnError = new Label((Composite)this.shell, 131072);
        this.wlStopOnError.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.StopOnError.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStopOnError);
        this.fdlStopOnError = new FormData();
        this.fdlStopOnError.left = new FormAttachment(0, 0);
        this.fdlStopOnError.top = new FormAttachment((Control)this.wDelimiter, margin);
        this.fdlStopOnError.right = new FormAttachment(middle, -margin);
        this.wlStopOnError.setLayoutData((Object)this.fdlStopOnError);
        this.wStopOnError = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wStopOnError);
        this.fdStopOnError = new FormData();
        this.fdStopOnError.left = new FormAttachment(middle, 0);
        this.fdStopOnError.top = new FormAttachment((Control)this.wDelimiter, margin);
        this.fdStopOnError.right = new FormAttachment(100, 0);
        this.wStopOnError.setLayoutData((Object)this.fdStopOnError);
        this.wStopOnError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PGBulkLoaderDialog.this.input.setChanged();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wSQL}, margin, null);
        this.wlReturn = new Label((Composite)this.shell, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wStopOnError, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        int UpInsCols = 3;
        int UpInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.ColumnInfo.DateMask", (String[])new String[0]), 2, new String[]{"", BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.PassThrough.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DateMask.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DateTimeMask.Label", (String[])new String[0])}, true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.wGetLU = new Button((Composite)this.shell, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        this.fdGetLU = new FormData();
        this.fdGetLU.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)this.fdGetLU);
        this.wDoMapping = new Button((Composite)this.shell, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wGetLU, margin);
        this.fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                PGBulkLoaderDialog.this.generateMappings();
            }
        });
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment((Control)this.wDoMapping, -margin);
        this.fdReturn.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wReturn.setLayoutData((Object)this.fdReturn);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = PGBulkLoaderDialog.this.transMeta.findStep(PGBulkLoaderDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = PGBulkLoaderDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            PGBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        PGBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        PGBulkLoaderDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                PGBulkLoaderDialog.this.ok();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                PGBulkLoaderDialog.this.getUpdate();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                PGBulkLoaderDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                PGBulkLoaderDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PGBulkLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wDbNameOverride.addSelectionListener(this.lsDef);
        this.wEnclosure.addSelectionListener(this.lsDef);
        this.wDelimiter.addSelectionListener(this.lsDef);
        this.wStopOnError.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PGBulkLoaderDialog.this.cancel();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PGBulkLoaderDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        String action;
        this.logDebug(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getFieldTable() != null) {
            for (int i = 0; i < this.input.getFieldTable().length; ++i) {
                String dateMask;
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getFieldTable()[i] != null) {
                    item.setText(1, this.input.getFieldTable()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                if ((dateMask = this.input.getDateMask()[i]) != null) {
                    if ("PASS THROUGH".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.PassThrough.Label", (String[])new String[0]));
                        continue;
                    }
                    if ("DATE".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DateMask.Label", (String[])new String[0]));
                        continue;
                    }
                    if ("DATETIME".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DateTimeMask.Label", (String[])new String[0]));
                        continue;
                    }
                    item.setText(3, "");
                    continue;
                }
                item.setText(3, "");
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getDelimiter() != null) {
            this.wDelimiter.setText(this.input.getDelimiter());
        }
        if (this.input.getEnclosure() != null) {
            this.wEnclosure.setText(this.input.getEnclosure());
        }
        this.wStopOnError.setSelection(this.input.isStopOnError());
        if (this.input.getDbNameOverride() != null) {
            this.wDbNameOverride.setText(this.input.getDbNameOverride());
        }
        if ("INSERT".equals(action = this.input.getLoadAction())) {
            this.wLoadAction.select(0);
        } else if ("TRUNCATE".equals(action)) {
            this.wLoadAction.select(1);
        } else {
            this.logDebug("Internal error: load_action set to default 'insert'");
            this.wLoadAction.select(0);
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(PGBulkLoaderMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrfields);
        inf.setDbNameOverride(this.wDbNameOverride.getText());
        this.logDebug(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            inf.getFieldTable()[i] = item.getText(1);
            inf.getFieldStream()[i] = item.getText(2);
            inf.getDateMask()[i] = BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.PassThrough.Label", (String[])new String[0]).equals(item.getText(3)) ? "PASS THROUGH" : (BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DateMask.Label", (String[])new String[0]).equals(item.getText(3)) ? "DATE" : (BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DateTimeMask.Label", (String[])new String[0]).equals(item.getText(3)) ? "DATETIME" : ""));
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setDelimiter(this.wDelimiter.getText());
        inf.setEnclosure(this.wEnclosure.getText());
        inf.setStopOnError(this.wStopOnError.getSelection());
        String action = this.wLoadAction.getText();
        if (BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("INSERT");
        } else if (BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("TRUNCATE");
        } else {
            this.logDebug("Internal error: load_action set to default 'insert', value found '" + action + "'.");
            inf.setLoadAction("INSERT");
        }
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.getType() == 3) {
                            tableItem.setText(3, BaseMessages.getString((Class)PKG, (String)"PGBulkLoaderDialog.DateMask.Label", (String[])new String[0]));
                        } else {
                            tableItem.setText(3, "");
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (TableItemInsertListener)listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            PGBulkLoaderMeta info = new PGBulkLoaderMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!(PGBulkLoaderDialog.this.wTable.isDisposed() || PGBulkLoaderDialog.this.wConnection.isDisposed() || PGBulkLoaderDialog.this.wSchema.isDisposed())) {
                    DatabaseMeta ci;
                    String tableName = PGBulkLoaderDialog.this.wTable.getText();
                    String connectionName = PGBulkLoaderDialog.this.wConnection.getText();
                    String schemaName = PGBulkLoaderDialog.this.wSchema.getText();
                    for (ColumnInfo colInfo : PGBulkLoaderDialog.this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)tableName) && (ci = PGBulkLoaderDialog.this.transMeta.findDatabase(connectionName)) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(PGBulkLoaderDialog.this.transMeta.environmentSubstitute(schemaName), PGBulkLoaderDialog.this.transMeta.environmentSubstitute(tableName));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null != r && null != (fieldNames = r.getFieldNames())) {
                                for (ColumnInfo colInfo : PGBulkLoaderDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(fieldNames);
                                }
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : PGBulkLoaderDialog.this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                        finally {
                            try {
                                if (db != null) {
                                    db.disconnect();
                                }
                            }
                            catch (Exception ignored) {
                                db = null;
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

