/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.eigenbase.resgen.FileTask;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.ResourceGenTask;
import org.eigenbase.resgen.Util;

class PropertiesFileTask
extends FileTask {
    final Locale locale;

    PropertiesFileTask(ResourceGenTask.Include include, String fileName) {
        this.include = include;
        this.fileName = fileName;
        this.className = Util.fileNameToClassName(fileName, ".properties");
        this.locale = Util.fileNameToLocale(fileName, ".properties");
    }

    void process(ResourceGen generator) throws IOException {
        String s = Util.fileNameSansLocale(this.fileName, ".properties");
        File file = new File(this.include.root.src, s + ".xml");
        URL url = Util.convertPathToURL(file);
        ResourceDef.ResourceBundle resourceList = Util.load(url);
        if (this.outputJava) {
            this.generateJava(generator, resourceList, this.locale);
        }
        if (this.outputCpp) {
            // empty if block
        }
    }
}

