/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.ref.SoftReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import mondrian.olap.Util;
import mondrian.util.Pair;

public class ExpiringReference<T>
extends SoftReference<T> {
    T hardRef;
    long expiry = Long.MIN_VALUE;
    private static final Timer timer = new Timer("mondrian.util.ExpiringReference$timer", true);

    public ExpiringReference(T ref, String timeout) {
        super(ref);
        this.setTimer(ref, timeout);
    }

    private synchronized void setTimer(T referent, String timeoutString) {
        Pair<Long, TimeUnit> pair = Util.parseInterval(timeoutString, null);
        long timeout = ((TimeUnit)((Object)pair.right)).toMillis((Long)pair.left);
        if (timeout == Long.MIN_VALUE && this.expiry != Long.MIN_VALUE) {
            return;
        }
        if (timeout == 0L) {
            this.expiry = Long.MAX_VALUE;
            this.hardRef = referent;
            return;
        }
        if (timeout > 0L) {
            long newExpiry = System.currentTimeMillis() + timeout;
            if (newExpiry > this.expiry) {
                this.expiry = newExpiry;
            }
            this.hardRef = referent;
            timer.schedule(this.getTask(), timeout + 10L);
            return;
        }
        this.hardRef = null;
    }

    TimerTask getTask() {
        return new TimerTask(){

            @Override
            public void run() {
                if (ExpiringReference.this.expiry <= System.currentTimeMillis()) {
                    ExpiringReference.this.hardRef = null;
                }
            }
        };
    }

    @Override
    public synchronized T get() {
        return this.get("-9223372036854775808ms");
    }

    public synchronized T get(String timeout) {
        Object weakRef = super.get();
        if (weakRef != null) {
            this.setTimer(weakRef, timeout);
        }
        return weakRef;
    }
}

