/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class EnumValueConverter
implements ValueConverter {
    private Class enumClass;

    public EnumValueConverter(Class enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public String toAttributeValue(Object o) throws BeanException {
        if (!(o instanceof Enum)) {
            throw new BeanException();
        }
        Enum e = (Enum)o;
        return e.name();
    }

    @Override
    public Object toPropertyValue(String s) throws BeanException {
        try {
            return Enum.valueOf(this.enumClass, s);
        }
        catch (Exception e) {
            throw new BeanException("Failed to convert enum from string " + s, e);
        }
    }
}

