/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.pentaho.reporting.engine.classic.core.DataRow;

public class ReportParameterValues
implements Cloneable,
Serializable,
DataRow {
    private LinkedHashMap<String, Object> linkedMap;

    public ReportParameterValues() {
        this.linkedMap = new LinkedHashMap();
    }

    public ReportParameterValues(ReportParameterValues values) {
        if (values == null) {
            throw new NullPointerException();
        }
        this.linkedMap = (LinkedHashMap)values.linkedMap.clone();
    }

    public Object put(String col, Object value) {
        if (col == null) {
            throw new NullPointerException();
        }
        return this.linkedMap.put(col, value);
    }

    @Override
    public Object get(String col) {
        return this.linkedMap.get(col);
    }

    @Override
    public String[] getColumnNames() {
        return this.linkedMap.keySet().toArray(new String[this.linkedMap.size()]);
    }

    @Override
    public boolean isChanged(String name) {
        return false;
    }

    public Object clone() {
        try {
            ReportParameterValues o = (ReportParameterValues)super.clone();
            o.linkedMap = (LinkedHashMap)this.linkedMap.clone();
            return o;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    public void putAll(DataRow dataRow) {
        if (dataRow == null) {
            throw new NullPointerException();
        }
        String[] names = dataRow.getColumnNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.put(name, dataRow.get(name));
        }
    }

    public void clear() {
        this.linkedMap.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReportParameterValues");
        sb.append("{linkedMap=").append(this.linkedMap);
        sb.append('}');
        return sb.toString();
    }
}

