/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.LegacyUpdateHandler;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;

public class LegacyUpdateStructureVisitor
extends AbstractStructureVisitor {
    private int version;

    public void performUpdate(MasterReport report) {
        this.version = report.getCompatibilityLevel();
        if (this.version == -1) {
            return;
        }
        super.inspect(report);
    }

    public void performUpdate(SubReport report) {
        ReportDefinition reportDefinition = report.getMasterReport();
        if (reportDefinition == null) {
            return;
        }
        MasterReport masterReport = (MasterReport)reportDefinition;
        this.version = masterReport.getCompatibilityLevel();
        if (this.version == -1) {
            return;
        }
        super.inspect(report);
    }

    @Override
    protected void inspectAttributeExpression(ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expression instanceof LegacyUpdateHandler) {
            LegacyUpdateHandler handler = (LegacyUpdateHandler)((Object)expression);
            handler.reconfigureForCompatibility(this.version);
        }
    }

    @Override
    protected void inspectStyleExpression(ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expression instanceof LegacyUpdateHandler) {
            LegacyUpdateHandler handler = (LegacyUpdateHandler)((Object)expression);
            handler.reconfigureForCompatibility(this.version);
        }
    }

    @Override
    protected void inspectExpression(AbstractReportDefinition report, Expression expression) {
        if (expression instanceof LegacyUpdateHandler) {
            LegacyUpdateHandler handler = (LegacyUpdateHandler)((Object)expression);
            handler.reconfigureForCompatibility(this.version);
        }
    }
}

