/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleChangeListener;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class StyleChangeSupport {
    private ArrayList listeners;
    private final ElementStyleSheet source;

    public StyleChangeSupport(ElementStyleSheet source) {
        this.source = source;
    }

    public void addListener(StyleChangeListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(5);
        }
        this.listeners.add(new WeakReference<StyleChangeListener>(l));
    }

    public void removeListener(StyleChangeListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public void fireStyleChanged(StyleKey key, Object value) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<WeakReference> removeList = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            WeakReference ref = (WeakReference)this.listeners.get(i);
            StyleChangeListener l = (StyleChangeListener)ref.get();
            if (l != null) {
                l.styleChanged(this.source, key, value);
                continue;
            }
            if (removeList == null) {
                removeList = new ArrayList<WeakReference>(5);
            }
            removeList.add(ref);
        }
        if (removeList != null) {
            this.listeners.removeAll(removeList);
        }
    }

    public void fireStyleRemoved(StyleKey key) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<WeakReference> removeList = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            WeakReference ref = (WeakReference)this.listeners.get(i);
            StyleChangeListener l = (StyleChangeListener)ref.get();
            if (l != null) {
                l.styleRemoved(this.source, key);
                continue;
            }
            if (removeList == null) {
                removeList = new ArrayList<WeakReference>(5);
            }
            removeList.add(ref);
        }
        if (removeList != null) {
            this.listeners.removeAll(removeList);
        }
    }
}

