/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;

public class BundleWriterHandlerRegistry {
    private static final BundleWriterHandlerRegistry instance = new BundleWriterHandlerRegistry();
    private ArrayList<Class<? extends BundleWriterHandler>> masterreportWriteHandlers = new ArrayList();
    private ArrayList<Class<? extends BundleWriterHandler>> subreportWriteHandlers = new ArrayList();
    private DefaultTagDescription writerTagDescription = new DefaultTagDescription();

    public static BundleWriterHandlerRegistry getInstance() {
        return instance;
    }

    private BundleWriterHandlerRegistry() {
    }

    public BundleWriterHandler[] getWriteHandlers(boolean master) {
        ArrayList<Class<? extends BundleWriterHandler>> list = master ? this.masterreportWriteHandlers : this.subreportWriteHandlers;
        ArrayList<BundleWriterHandler> retval = new ArrayList<BundleWriterHandler>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Class<? extends BundleWriterHandler> c = list.get(i);
                retval.add(c.newInstance());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval.toArray(new BundleWriterHandler[retval.size()]);
    }

    public void registerMasterReportHandler(Class<? extends BundleWriterHandler> writeHandler) {
        if (writeHandler == null) {
            return;
        }
        this.masterreportWriteHandlers.add(writeHandler);
    }

    public void registerSubReportHandler(Class<? extends BundleWriterHandler> writeHandler) {
        if (writeHandler == null) {
            return;
        }
        this.subreportWriteHandlers.add(writeHandler);
    }

    public void setElementHasCData(String namespaceUri, String tagName, boolean hasCData) {
        this.writerTagDescription.setElementHasCData(namespaceUri, tagName, hasCData);
    }

    public void setNamespaceHasCData(String namespaceUri, boolean hasCData) {
        this.writerTagDescription.setNamespaceHasCData(namespaceUri, hasCData);
    }

    public DefaultTagDescription createWriterTagDescription() {
        return this.writerTagDescription.clone();
    }
}

