/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.CellStyleProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelCellStyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelFontFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFFontWrapper;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextRotation;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class HSSFCellStyleProducer
implements CellStyleProducer {
    private static final Log logger = LogFactory.getLog(HSSFCellStyleProducer.class);
    private ExcelFontFactory fontFactory;
    private Workbook workbook;
    private DataFormat dataFormat;
    private HashMap<HSSFCellStyleKey, CellStyle> styleCache;
    private boolean warningDone;
    private boolean hardLimit;
    private ExcelColorProducer colorProducer;
    private ExcelColorProducer fontColorProducer;

    public HSSFCellStyleProducer(Workbook workbook, boolean hardLimit, ExcelColorProducer colorProducer, ExcelColorProducer fontColorProducer) {
        this.fontColorProducer = fontColorProducer;
        if (workbook == null) {
            throw new NullPointerException();
        }
        if (colorProducer == null) {
            throw new NullPointerException();
        }
        this.colorProducer = colorProducer;
        this.styleCache = new HashMap();
        this.workbook = workbook;
        this.fontFactory = new ExcelFontFactory(workbook, fontColorProducer);
        this.dataFormat = workbook.createDataFormat();
        this.hardLimit = hardLimit;
        if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xssfWorkbook = (XSSFWorkbook)workbook;
            int predefinedStyles = workbook.getNumCellStyles();
            for (int i = 0; i < predefinedStyles; ++i) {
                XSSFCellStyle cellStyleAt = xssfWorkbook.getCellStyleAt(i);
                this.styleCache.put(new HSSFCellStyleKey(cellStyleAt), (CellStyle)cellStyleAt);
            }
        } else {
            int predefinedStyles = workbook.getNumCellStyles();
            for (int i = 0; i < predefinedStyles; ++i) {
                CellStyle cellStyleAt = workbook.getCellStyleAt(i);
                this.styleCache.put(new HSSFCellStyleKey(cellStyleAt), cellStyleAt);
            }
        }
    }

    @Override
    public CellStyle createCellStyle(InstanceID id, StyleSheet element, CellBackground bg) {
        HSSFCellStyleKey styleKey = new HSSFCellStyleKey(bg, element, this.dataFormat, this.fontFactory, this.colorProducer, this.fontColorProducer);
        if (this.styleCache.containsKey(styleKey)) {
            return this.styleCache.get(styleKey);
        }
        if (this.styleCache.size() > 4000) {
            if (!this.warningDone) {
                logger.warn((Object)"HSSFCellStyleProducer has reached the limit of 4000 created styles.");
                this.warningDone = true;
            }
            if (this.hardLimit) {
                logger.warn((Object)"HSSFCellStyleProducer will not create more styles. New cells will not have any style.");
                return null;
            }
        }
        ExcelCellStyleBuilder builder = new ExcelCellStyleBuilder(this.workbook);
        builder.withRotation(element);
        builder.withElementStyle(element, styleKey);
        builder.withBackgroundStyle(bg, styleKey);
        CellStyle hssfCellStyle = builder.build();
        this.styleCache.put(styleKey, hssfCellStyle);
        return hssfCellStyle;
    }

    protected static HorizontalAlignment convertHorizontalAlignment(ElementAlignment e) {
        if (ElementAlignment.LEFT.equals(e)) {
            return HorizontalAlignment.LEFT;
        }
        if (ElementAlignment.RIGHT.equals(e)) {
            return HorizontalAlignment.RIGHT;
        }
        if (ElementAlignment.JUSTIFY.equals(e)) {
            return HorizontalAlignment.JUSTIFY;
        }
        if (ElementAlignment.CENTER.equals(e)) {
            return HorizontalAlignment.CENTER;
        }
        throw new IllegalArgumentException("Invalid alignment");
    }

    protected static VerticalAlignment convertVerticalAlignment(ElementAlignment e) {
        if (ElementAlignment.TOP.equals(e)) {
            return VerticalAlignment.TOP;
        }
        if (ElementAlignment.BOTTOM.equals(e)) {
            return VerticalAlignment.BOTTOM;
        }
        if (ElementAlignment.MIDDLE.equals(e)) {
            return VerticalAlignment.CENTER;
        }
        throw new IllegalArgumentException("Invalid alignment");
    }

    protected static BorderStyle translateStroke(org.pentaho.reporting.engine.classic.core.style.BorderStyle borderStyle, long widthRaw) {
        double width = StrictGeomUtility.toExternalValue(widthRaw);
        if (org.pentaho.reporting.engine.classic.core.style.BorderStyle.NONE.equals(borderStyle)) {
            return BorderStyle.NONE;
        }
        if (org.pentaho.reporting.engine.classic.core.style.BorderStyle.DASHED.equals(borderStyle)) {
            return width <= 1.5 ? BorderStyle.DASHED : BorderStyle.MEDIUM_DASHED;
        }
        if (org.pentaho.reporting.engine.classic.core.style.BorderStyle.DOT_DOT_DASH.equals(borderStyle)) {
            return width <= 1.5 ? BorderStyle.DASH_DOT_DOT : BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (org.pentaho.reporting.engine.classic.core.style.BorderStyle.DOT_DASH.equals(borderStyle)) {
            return width <= 1.5 ? BorderStyle.DASH_DOT : BorderStyle.MEDIUM_DASH_DOT;
        }
        if (org.pentaho.reporting.engine.classic.core.style.BorderStyle.DOTTED.equals(borderStyle)) {
            return BorderStyle.DOTTED;
        }
        if (org.pentaho.reporting.engine.classic.core.style.BorderStyle.DOUBLE.equals(borderStyle)) {
            return BorderStyle.DOUBLE;
        }
        if (width == 0.0) {
            return BorderStyle.NONE;
        }
        if (width <= 0.5) {
            return BorderStyle.HAIR;
        }
        if (width <= 1.0) {
            return BorderStyle.THIN;
        }
        if (width <= 1.5) {
            return BorderStyle.MEDIUM;
        }
        return BorderStyle.THICK;
    }

    @Override
    public ExcelFontFactory getFontFactory() {
        return this.fontFactory;
    }

    static class HSSFCellStyleKey {
        private short color;
        private Color xColor;
        private BorderStyle borderStrokeTop;
        private BorderStyle borderStrokeBottom;
        private BorderStyle borderStrokeLeft;
        private BorderStyle borderStrokeRight;
        private short colorTop;
        private Color xColorTop;
        private short colorLeft;
        private Color xColorLeft;
        private short colorBottom;
        private Color xColorBottom;
        private short colorRight;
        private Color xColorRight;
        private boolean wrapText;
        private HorizontalAlignment horizontalAlignment;
        private VerticalAlignment verticalAlignment;
        private short font;
        private short dataStyle;
        private short indention;
        private TextRotation textRotation;
        private Integer hashCode;

        protected HSSFCellStyleKey(CellBackground background, StyleSheet contentStyle, DataFormat dataFormat, ExcelFontFactory fontFactory, ExcelColorProducer colorProducer, ExcelColorProducer fontColorProducer) {
            if (dataFormat == null) {
                throw new NullPointerException();
            }
            if (fontFactory == null) {
                throw new NullPointerException();
            }
            this.dataStyle = 0;
            this.color = HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
            this.colorBottom = HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
            this.colorLeft = HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
            this.colorRight = HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
            this.colorTop = HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
            if (background != null) {
                if (background.getBackgroundColor() != null) {
                    this.color = colorProducer.getNearestColor(background.getBackgroundColor());
                    this.xColor = background.getBackgroundColor();
                }
                BorderEdge bottom = background.getBottom();
                this.colorBottom = colorProducer.getNearestColor(bottom.getColor());
                this.xColorBottom = bottom.getColor();
                this.borderStrokeBottom = HSSFCellStyleProducer.translateStroke(bottom.getBorderStyle(), bottom.getWidth());
                BorderEdge left = background.getLeft();
                this.colorLeft = colorProducer.getNearestColor(left.getColor());
                this.xColorLeft = left.getColor();
                this.borderStrokeLeft = HSSFCellStyleProducer.translateStroke(left.getBorderStyle(), left.getWidth());
                BorderEdge top = background.getTop();
                this.colorTop = colorProducer.getNearestColor(top.getColor());
                this.xColorTop = top.getColor();
                this.borderStrokeTop = HSSFCellStyleProducer.translateStroke(top.getBorderStyle(), top.getWidth());
                BorderEdge right = background.getRight();
                this.colorRight = colorProducer.getNearestColor(right.getColor());
                this.xColorRight = right.getColor();
                this.borderStrokeRight = HSSFCellStyleProducer.translateStroke(right.getBorderStyle(), right.getWidth());
            }
            if (contentStyle != null) {
                Color textColor = (Color)contentStyle.getStyleProperty(ElementStyleKeys.PAINT);
                HSSFFontWrapper wrapper = new HSSFFontWrapper(contentStyle, fontColorProducer.getNearestColor(textColor));
                Font excelFont = fontFactory.getExcelFont(wrapper);
                this.font = excelFont.getIndex();
                ElementAlignment horizontal = (ElementAlignment)contentStyle.getStyleProperty(ElementStyleKeys.ALIGNMENT);
                this.horizontalAlignment = HSSFCellStyleProducer.convertHorizontalAlignment(horizontal);
                ElementAlignment vertical = (ElementAlignment)contentStyle.getStyleProperty(ElementStyleKeys.VALIGNMENT);
                this.verticalAlignment = HSSFCellStyleProducer.convertVerticalAlignment(vertical);
                String dataStyle = (String)contentStyle.getStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING);
                if (dataStyle != null) {
                    this.dataStyle = dataFormat.getFormat(dataStyle);
                }
                this.wrapText = this.isWrapText(contentStyle);
                this.indention = this.getIndention(contentStyle);
                this.textRotation = (TextRotation)contentStyle.getStyleProperty(TextStyleKeys.TEXT_ROTATION, null);
            }
        }

        private boolean isWrapText(StyleSheet styleSheet) {
            Object excelWrap = styleSheet.getStyleProperty(ElementStyleKeys.EXCEL_WRAP_TEXT);
            if (excelWrap != null) {
                return Boolean.TRUE.equals(excelWrap);
            }
            return TextWrap.WRAP.equals(styleSheet.getStyleProperty(TextStyleKeys.TEXT_WRAP, TextWrap.WRAP));
        }

        private Short getIndention(StyleSheet styleSheet) {
            Short indention = (Short)styleSheet.getStyleProperty(ElementStyleKeys.EXCEL_INDENTION);
            return indention == null ? (short)0 : indention;
        }

        protected HSSFCellStyleKey(XSSFCellStyle style) {
            this.color = style.getFillForegroundColor();
            this.colorTop = style.getTopBorderColor();
            this.colorLeft = style.getLeftBorderColor();
            this.colorBottom = style.getBottomBorderColor();
            this.colorRight = style.getRightBorderColor();
            this.xColor = HSSFCellStyleKey.createColor(style.getFillBackgroundXSSFColor());
            this.xColorTop = HSSFCellStyleKey.createColor(style.getTopBorderXSSFColor());
            this.xColorLeft = HSSFCellStyleKey.createColor(style.getLeftBorderXSSFColor());
            this.xColorBottom = HSSFCellStyleKey.createColor(style.getBottomBorderXSSFColor());
            this.xColorRight = HSSFCellStyleKey.createColor(style.getRightBorderXSSFColor());
            this.borderStrokeTop = style.getBorderTopEnum();
            this.borderStrokeLeft = style.getBorderLeftEnum();
            this.borderStrokeBottom = style.getBorderBottomEnum();
            this.borderStrokeRight = style.getBorderRightEnum();
            this.dataStyle = style.getDataFormat();
            this.font = style.getFontIndex();
            this.horizontalAlignment = style.getAlignmentEnum();
            this.verticalAlignment = style.getVerticalAlignmentEnum();
            this.wrapText = style.getWrapText();
            this.textRotation = TextRotation.getInstance(style.getRotation());
        }

        private static Color createColor(XSSFColor color) {
            if (color == null) {
                return null;
            }
            byte[] rgb = color.getRGB();
            return new Color(0xFF & rgb[0], 0xFF & rgb[1], 0xFF & rgb[2]);
        }

        protected HSSFCellStyleKey(CellStyle style) {
            this.color = style.getFillForegroundColor();
            this.colorTop = style.getTopBorderColor();
            this.colorLeft = style.getLeftBorderColor();
            this.colorBottom = style.getBottomBorderColor();
            this.colorRight = style.getRightBorderColor();
            this.borderStrokeTop = style.getBorderTopEnum();
            this.borderStrokeLeft = style.getBorderLeftEnum();
            this.borderStrokeBottom = style.getBorderBottomEnum();
            this.borderStrokeRight = style.getBorderRightEnum();
            this.dataStyle = style.getDataFormat();
            this.font = style.getFontIndex();
            this.horizontalAlignment = style.getAlignmentEnum();
            this.verticalAlignment = style.getVerticalAlignmentEnum();
            this.wrapText = style.getWrapText();
            this.textRotation = TextRotation.getInstance(style.getRotation());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HSSFCellStyleKey that = (HSSFCellStyleKey)o;
            if (this.borderStrokeBottom != that.borderStrokeBottom) {
                return false;
            }
            if (this.borderStrokeLeft != that.borderStrokeLeft) {
                return false;
            }
            if (this.borderStrokeRight != that.borderStrokeRight) {
                return false;
            }
            if (this.borderStrokeTop != that.borderStrokeTop) {
                return false;
            }
            if (this.color != that.color) {
                return false;
            }
            if (this.colorBottom != that.colorBottom) {
                return false;
            }
            if (this.colorLeft != that.colorLeft) {
                return false;
            }
            if (this.colorRight != that.colorRight) {
                return false;
            }
            if (this.colorTop != that.colorTop) {
                return false;
            }
            if (this.dataStyle != that.dataStyle) {
                return false;
            }
            if (this.font != that.font) {
                return false;
            }
            if (this.horizontalAlignment != that.horizontalAlignment) {
                return false;
            }
            if (this.verticalAlignment != that.verticalAlignment) {
                return false;
            }
            if (this.wrapText != that.wrapText) {
                return false;
            }
            if (this.xColor == null ? that.xColor != null : !this.xColor.equals(that.xColor)) {
                return false;
            }
            if (this.xColorRight == null ? that.xColorRight != null : !this.xColorRight.equals(that.xColorRight)) {
                return false;
            }
            if (this.xColorLeft == null ? that.xColorLeft != null : !this.xColorLeft.equals(that.xColorLeft)) {
                return false;
            }
            if (this.xColorTop == null ? that.xColorTop != null : !this.xColorTop.equals(that.xColorTop)) {
                return false;
            }
            if (this.xColorBottom == null) {
                if (that.xColorBottom != null) {
                    return false;
                }
            } else {
                return this.xColorBottom.equals(that.xColorBottom);
            }
            if (this.textRotation == null) {
                return that.textRotation == null;
            }
            return this.textRotation.equals(that.textRotation);
        }

        public int hashCode() {
            if (this.hashCode == null) {
                int result = this.color;
                result = 29 * result + (this.borderStrokeTop == null ? 0 : this.borderStrokeTop.hashCode());
                result = 29 * result + (this.borderStrokeBottom == null ? 0 : this.borderStrokeBottom.hashCode());
                result = 29 * result + (this.borderStrokeLeft == null ? 0 : this.borderStrokeLeft.hashCode());
                result = 29 * result + (this.borderStrokeRight == null ? 0 : this.borderStrokeRight.hashCode());
                result = 29 * result + this.colorTop;
                result = 29 * result + this.colorLeft;
                result = 29 * result + this.colorBottom;
                result = 29 * result + this.colorRight;
                result = 29 * result + (this.wrapText ? 1 : 0);
                result = 29 * result + (this.horizontalAlignment == null ? 0 : this.horizontalAlignment.hashCode());
                result = 29 * result + (this.verticalAlignment == null ? 0 : this.verticalAlignment.hashCode());
                result = 29 * result + this.font;
                result = 29 * result + this.dataStyle;
                result = 29 * result + this.indention;
                result = 29 * result + (this.xColor == null ? 0 : this.xColor.hashCode());
                result = 29 * result + (this.xColorTop == null ? 0 : this.xColorTop.hashCode());
                result = 29 * result + (this.xColorLeft == null ? 0 : this.xColorLeft.hashCode());
                result = 29 * result + (this.xColorBottom == null ? 0 : this.xColorBottom.hashCode());
                result = 29 * result + (this.xColorRight == null ? 0 : this.xColorRight.hashCode());
                result = 29 * result + (this.textRotation == null ? 0 : this.textRotation.hashCode());
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public short getColor() {
            return this.color;
        }

        public BorderStyle getBorderStrokeTop() {
            return this.borderStrokeTop;
        }

        public BorderStyle getBorderStrokeBottom() {
            return this.borderStrokeBottom;
        }

        public BorderStyle getBorderStrokeLeft() {
            return this.borderStrokeLeft;
        }

        public BorderStyle getBorderStrokeRight() {
            return this.borderStrokeRight;
        }

        public short getColorTop() {
            return this.colorTop;
        }

        public short getColorLeft() {
            return this.colorLeft;
        }

        public short getColorBottom() {
            return this.colorBottom;
        }

        public short getColorRight() {
            return this.colorRight;
        }

        public Color getExtendedColor() {
            return this.xColor;
        }

        public Color getExtendedColorTop() {
            return this.xColorTop;
        }

        public Color getExtendedColorLeft() {
            return this.xColorLeft;
        }

        public Color getExtendedColorBottom() {
            return this.xColorBottom;
        }

        public Color getExtendedColorRight() {
            return this.xColorRight;
        }

        public boolean isWrapText() {
            return this.wrapText;
        }

        public HorizontalAlignment getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public VerticalAlignment getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public short getFont() {
            return this.font;
        }

        public short getDataStyle() {
            return this.dataStyle;
        }

        public short getIndention() {
            return this.indention;
        }
    }
}

