/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

public class PlaintextDataChunk {
    private final String text;
    private final String font;
    private boolean bold;
    private boolean italic;
    private final int x;
    private final int y;
    private final int width;
    private boolean underline;
    private boolean strikethrough;

    protected PlaintextDataChunk(String text, String font, boolean bold, boolean italic, boolean underline, boolean strikethrough, int x, int y, int w) {
        if (font == null) {
            throw new NullPointerException("Font must not be null");
        }
        if (text == null) {
            throw new NullPointerException("Text must not be null");
        }
        if (x < 0) {
            throw new IllegalArgumentException();
        }
        if (y < 0) {
            throw new IllegalArgumentException();
        }
        if (w < 1) {
            throw new IllegalArgumentException("PlaintextDataChunk: Width is empty or negative. " + w);
        }
        if (w > text.length()) {
            throw new IllegalArgumentException("Size limit: " + w + " vs. " + text.length());
        }
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.x = x;
        this.y = y;
        this.width = w;
        this.text = text;
        this.font = font;
        this.bold = bold;
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public String getText() {
        return this.text;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public String getFont() {
        return this.font;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }
}

