/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlReportUtil;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;

public class FastHtmlReportUtil {
    public static void processStreamHtml(MasterReport report, OutputStream out) throws ReportProcessingException, IOException {
        ReportStructureValidator validator = new ReportStructureValidator();
        if (!validator.isValidForFastProcessing(report)) {
            HtmlReportUtil.createStreamHTML(report, out);
            return;
        }
        StreamRepository targetRepository = new StreamRepository(out);
        ContentLocation targetRoot = targetRepository.getRoot();
        FastHtmlContentItems contentItems = new FastHtmlContentItems();
        contentItems.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
        contentItems.setDataWriter(null, null);
        contentItems.setUrlRewriter(new FileSystemURLRewriter());
        FastHtmlExportProcessor reportProcessor = new FastHtmlExportProcessor(report, contentItems);
        reportProcessor.processReport();
        reportProcessor.close();
        out.flush();
    }
}

