/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.csv;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.csv.CSVProcessor;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public final class CSVDataReportUtil {
    private CSVDataReportUtil() {
    }

    public static void createCSV(MasterReport report, Writer writer) throws ReportProcessingException {
        CSVProcessor pr = new CSVProcessor(report);
        pr.setWriter(writer);
        pr.processReport();
    }

    public static void createCSV(MasterReport report, String filename) throws ReportProcessingException, IOException {
        String encoding = report.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
        CSVDataReportUtil.createCSV(report, filename, encoding);
    }

    public static void createCSV(MasterReport report, String filename, String encoding) throws ReportProcessingException, IOException {
        CSVProcessor pr = new CSVProcessor(report);
        FileOutputStream outstr = new FileOutputStream(filename);
        BufferedWriter fout = new BufferedWriter(new OutputStreamWriter((OutputStream)outstr, encoding));
        pr.setWriter(fout);
        pr.processReport();
        ((Writer)fout).close();
    }

    public static void createCSV(MasterReport report, OutputStream outputStream, String encoding) throws ReportProcessingException, IOException {
        CSVProcessor pr = new CSVProcessor(report);
        BufferedWriter fout = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
        pr.setWriter(fout);
        pr.processReport();
        ((Writer)fout).flush();
    }
}

