/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.connections.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.writer.DataSourceMgmtWriter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class FileDataSourceMgmtWriter
implements DataSourceMgmtWriter {
    private static final String PROP_INDEX_TBS = "INDEX_TBS";
    private static final String PROP_DATA_TBS = "DATA_TBS";
    private static final String PROP_SERVERNAME = "SERVERNAME";
    private static final String PROP_PASSWORD = "PASSWORD";
    private static final String PROP_USERNAME = "USERNAME";
    private static final String PROP_PORT = "PORT";
    private static final String PROP_DATABASE_NAME = "DATABASE_NAME";
    private static final String PROP_HOST_NAME = "HOST_NAME";
    private static final String PROP_CONTYPE = "CONTYPE";
    private static final String PROP_TYPE = "TYPE";
    private static final String NODE_ROOT = "databaseMeta";
    private static final String NODE_ATTRIBUTES = "attributes";
    private static final String NODE_ATTRIBUTE = "attribute";

    @Override
    public void write(IDatabaseConnection[] connections, OutputStream out) throws IOException {
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.setDefaultNamespace("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0");
        tagDescription.setNamespaceHasCData("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", false);
        tagDescription.setElementHasCData("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", NODE_ATTRIBUTE, true);
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter(out, "UTF-8"), (TagDescription)tagDescription);
        writer.writeXmlDeclaration("UTF-8");
        AttributeList rootList = new AttributeList();
        rootList.addNamespaceDeclaration(null, "http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0");
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", "connections", rootList, false);
        for (int i = 0; i < connections.length; ++i) {
            IDatabaseConnection connection = connections[i];
            this.write(connection, writer);
        }
        writer.writeCloseTag();
        writer.flush();
    }

    private void write(IDatabaseConnection databaseConnection, XmlWriter writer) throws IOException {
        AttributeList rootAttrs = new AttributeList();
        if (databaseConnection.getDatabaseType() != null) {
            rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_TYPE, databaseConnection.getDatabaseType().getShortName());
        }
        String port = StringUtils.isEmpty((String)databaseConnection.getDatabasePort()) ? "0" : databaseConnection.getDatabasePort();
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", "name", databaseConnection.getName());
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", "id", databaseConnection.getId());
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_CONTYPE, this.setNull(databaseConnection.getAccessType().getName()));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_HOST_NAME, this.setNull(databaseConnection.getHostname()));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_DATABASE_NAME, this.setNull(databaseConnection.getDatabaseName()));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_PORT, String.valueOf(new Long(port)));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_USERNAME, this.setNull(databaseConnection.getUsername()));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_PASSWORD, this.setNull(databaseConnection.getPassword()));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_SERVERNAME, this.setNull(databaseConnection.getInformixServername()));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_DATA_TBS, this.setNull(databaseConnection.getDataTablespace()));
        rootAttrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_INDEX_TBS, this.setNull(databaseConnection.getIndexTablespace()));
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", NODE_ROOT, rootAttrs, false);
        Map attributes = databaseConnection.getAttributes();
        Set entries = attributes.entrySet();
        if (!entries.isEmpty()) {
            writer.writeTag(null, NODE_ATTRIBUTES, false);
            for (Map.Entry e : entries) {
                writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", NODE_ATTRIBUTE, "name", (String)e.getKey(), false);
                writer.writeTextNormalized((String)e.getValue(), false);
                writer.writeCloseTag();
            }
            writer.writeCloseTag();
        }
        writer.writeCloseTag();
    }

    private String setNull(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return value;
    }
}

