/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.connections.parser;

import java.util.Map;
import java.util.Properties;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.boot.ObjectFactory;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DatabaseMetaReadHandler
extends AbstractXmlReadHandler {
    private static final String PROP_INDEX_TBS = "INDEX_TBS";
    private static final String PROP_DATA_TBS = "DATA_TBS";
    private static final String PROP_SERVERNAME = "SERVERNAME";
    private static final String PROP_PASSWORD = "PASSWORD";
    private static final String PROP_USERNAME = "USERNAME";
    private static final String PROP_PORT = "PORT";
    private static final String PROP_DATABASE_NAME = "DATABASE_NAME";
    private static final String PROP_HOST_NAME = "HOST_NAME";
    private static final String PROP_CONTYPE = "CONTYPE";
    private static final String PROP_TYPE = "TYPE";
    private static final String NODE_ATTRIBUTES = "attributes";
    private static final String NODE_ATTRIBUTE = "attribute";
    private final DatabaseTypeHelper databaseTypeHelper;
    private DatabaseConnection databaseConnection;
    private PropertiesReadHandler propertiesReadHandler;

    public DatabaseMetaReadHandler() {
        ObjectFactory objectFactory = ClassicEngineBoot.getInstance().getObjectFactory();
        IDatabaseDialectService dialectService = (IDatabaseDialectService)objectFactory.get(IDatabaseDialectService.class);
        this.databaseTypeHelper = new DatabaseTypeHelper(dialectService.getDatabaseTypes());
    }

    public IDatabaseConnection getObject() throws SAXException {
        return this.databaseConnection;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        this.databaseConnection = new DatabaseConnection();
        String databaseType = attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_TYPE);
        if (databaseType != null) {
            this.databaseConnection.setDatabaseType(this.databaseTypeHelper.getDatabaseTypeByShortName(databaseType));
        } else {
            this.databaseConnection.setDatabaseType(null);
        }
        this.databaseConnection.setName(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", "name"));
        this.databaseConnection.setId(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", "id"));
        String accessType = attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_CONTYPE);
        this.databaseConnection.setAccessType(accessType != null ? DatabaseAccessType.getAccessTypeByName((String)accessType) : null);
        this.databaseConnection.setHostname(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_HOST_NAME));
        this.databaseConnection.setDatabaseName(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_DATABASE_NAME));
        this.databaseConnection.setDatabasePort(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_PORT));
        this.databaseConnection.setUsername(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_USERNAME));
        this.databaseConnection.setPassword(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_PASSWORD));
        this.databaseConnection.setInformixServername(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_SERVERNAME));
        this.databaseConnection.setDataTablespace(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_DATA_TBS));
        this.databaseConnection.setIndexTablespace(attrs.getValue("http://reporting.pentaho.org/namespaces/engine/classic/extensions/connections/1.0", PROP_INDEX_TBS));
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri) && NODE_ATTRIBUTES.equals(tagName)) {
            this.propertiesReadHandler = new PropertiesReadHandler(NODE_ATTRIBUTE);
            return this.propertiesReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.propertiesReadHandler == null) {
            return;
        }
        Properties result = this.propertiesReadHandler.getResult();
        for (Map.Entry<Object, Object> entry : result.entrySet()) {
            String code = (String)entry.getKey();
            String attribute = (String)entry.getValue();
            this.databaseConnection.getAttributes().put(code, attribute == null || attribute.length() == 0 ? "" : attribute);
        }
    }
}

