/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.bsf;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Map;
import org.apache.bsf.BSFManager;

public class BSFScriptableLanguagesPropertyEditor
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String text;

    @Override
    public void setValue(Object value) {
        String oldText = this.text;
        this.text = value instanceof String ? (String)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldText, this.text);
    }

    @Override
    public Object getValue() {
        return this.text;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return this.text;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    @Override
    public String[] getTags() {
        return InternalBSFManager.getRegisteredLanguages();
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private static class InternalBSFManager
    extends BSFManager {
        private InternalBSFManager() {
        }

        public static String[] getRegisteredLanguages() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : registeredEngines.entrySet()) {
                String lang = (String)entry.getKey();
                String className = (String)entry.getValue();
                try {
                    Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    list.add(lang);
                }
                catch (Throwable throwable) {}
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

