/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ExpressionMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ExpressionPropertyReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExpressionReadHandler
extends AbstractMetaDataReadHandler {
    private ArrayList<ExpressionPropertyReadHandler> propertyHandlers = new ArrayList();
    private SharedBeanInfo beanInfo;
    private ExpressionMetaDataBuilder builder = new ExpressionMetaDataBuilder();

    public ExpressionMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected boolean isDerivedName() {
        return true;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.getBuilder().layoutComputation(this.parseLayoutProcessorMode(attrs));
        this.getBuilder().impl(this.parseExpressionImpl(attrs));
        this.getBuilder().resultType(this.parseResultType(attrs));
        this.getBuilder().bundle(this.getBundle(), "");
        this.beanInfo = new SharedBeanInfo(this.getBuilder().getImpl());
    }

    private Class<?> parseResultType(Attributes attrs) throws ParseException {
        Class<?> resultType;
        String resultTypeText = attrs.getValue(this.getUri(), "result");
        if (resultTypeText == null) {
            throw new ParseException("Attribute 'result' is undefined", this.getLocator());
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ExpressionReadHandler.class);
            resultType = Class.forName(resultTypeText, false, loader);
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'result' is not valid", e, this.getLocator());
        }
        return resultType;
    }

    private int parseLayoutProcessorMode(Attributes attrs) {
        String layoutProcessorMode = attrs.getValue(this.getUri(), "layout-processor-mode");
        int layoutComputation = "global".equals(layoutProcessorMode) ? 2 : ("element".equals(layoutProcessorMode) ? 1 : 0);
        return layoutComputation;
    }

    private Class<? extends Expression> parseExpressionImpl(Attributes attrs) throws ParseException {
        Class expressionClass;
        String implText = attrs.getValue(this.getUri(), "class");
        if (implText == null) {
            throw new ParseException("Attribute 'class' is undefined", this.getLocator());
        }
        try {
            expressionClass = ObjectUtilities.loadAndValidate((String)implText, ExpressionReadHandler.class, Expression.class);
            if (expressionClass == null) {
                throw new ParseException("Attribute 'class' is not valid", this.getLocator());
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
        }
        return expressionClass;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            ExpressionPropertyReadHandler readHandler = new ExpressionPropertyReadHandler(this.beanInfo, this.getBundle());
            this.propertyHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.propertyHandlers.size(); ++i) {
            ExpressionPropertyReadHandler handler = this.propertyHandlers.get(i);
            this.getBuilder().property(handler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return new DefaultExpressionMetaData(this.getBuilder());
    }
}

