/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.text.RenderableTextFactory;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class ComplexTextFactory
implements RenderableTextFactory {
    @Override
    public RenderNode[] createText(int[] text, int offset, int length, StyleSheet layoutContext, ElementType elementType, InstanceID instanceId, ReportAttributeMap<Object> attributeMap) {
        List<String> strings = ComplexTextFactory.processText(text, offset, length);
        ArrayList<RenderableComplexText> result = new ArrayList<RenderableComplexText>();
        Iterator<String> lines = strings.iterator();
        while (lines.hasNext()) {
            String next = lines.next();
            if (next.isEmpty() && !lines.hasNext()) continue;
            RenderableComplexText rct = new RenderableComplexText(layoutContext, instanceId, elementType, attributeMap, next);
            rct.setForceLinebreak(lines.hasNext());
            result.add(rct);
        }
        return result.toArray(new RenderNode[result.size()]);
    }

    @Override
    public RenderNode[] finishText() {
        return new RenderNode[0];
    }

    @Override
    public void startText() {
    }

    public static List<String> processText(int[] text, int offset, int length) {
        ArrayList<String> result = new ArrayList<String>();
        int end = offset + length;
        int start = offset;
        State state = State.None;
        block12: for (int i = offset; i < end; ++i) {
            State oldState = state;
            int cp = text[i];
            switch (cp) {
                case 10: {
                    String txt;
                    state = State.LF;
                    switch (oldState) {
                        case CR: {
                            txt = new String(text, start, i - start - 1);
                            result.add(txt);
                            start = i + 1;
                            continue block12;
                        }
                        case LF: {
                            result.add("");
                            start = i + 1;
                            continue block12;
                        }
                    }
                    txt = new String(text, start, i - start);
                    result.add(txt);
                    start = i + 1;
                    continue block12;
                }
                case 13: {
                    state = State.CR;
                    if (oldState != State.CR) continue block12;
                    String txt = new String(text, start, i - start - 1);
                    result.add(txt);
                    start = i + 1;
                    continue block12;
                }
                default: {
                    state = State.None;
                    if (oldState != State.CR) continue block12;
                    String txt = new String(text, start, i - start);
                    result.add(txt);
                    start = i;
                }
            }
        }
        switch (state) {
            case LF: 
            case None: {
                result.add(new String(text, start, offset + length - start));
                break;
            }
            case CR: {
                result.add(new String(text, start, offset + length - start - 1));
                result.add("");
            }
        }
        return result;
    }

    private static enum State {
        None,
        LF,
        CR;

    }
}

