/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.richtext.html;

import java.awt.Color;
import java.text.NumberFormat;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.richtext.html.DefaultStyleBuilder;
import org.pentaho.reporting.engine.classic.core.layout.richtext.html.FilterStyleBuilder;
import org.pentaho.reporting.engine.classic.core.layout.richtext.html.HtmlColors;
import org.pentaho.reporting.engine.classic.core.layout.richtext.html.HtmlEncoderUtil;
import org.pentaho.reporting.engine.classic.core.layout.richtext.html.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class RichTextHtmlStyleBuilderFactory {
    private boolean safariLengthFix;
    private boolean useWhitespacePreWrap;
    private boolean enableRoundBorderCorner;

    public boolean isSafariLengthFix() {
        return this.safariLengthFix;
    }

    public boolean isUseWhitespacePreWrap() {
        return this.useWhitespacePreWrap;
    }

    public boolean isEnableRoundBorderCorner() {
        return this.enableRoundBorderCorner;
    }

    public DefaultStyleBuilder produceTextStyle(DefaultStyleBuilder styleBuilder, StyleSheet styleSheet) {
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        if (styleBuilder == null) {
            styleBuilder = new DefaultStyleBuilder();
        } else {
            styleBuilder.clear();
        }
        Color textColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT);
        Color backgroundColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
        if (backgroundColor != null) {
            styleBuilder.append(StyleBuilder.CSSKeys.BACKGROUND_COLOR, HtmlColors.getColorString(backgroundColor));
        }
        if (textColor != null) {
            styleBuilder.append(StyleBuilder.CSSKeys.COLOR, HtmlColors.getColorString(textColor));
        }
        this.processFontStyle(styleSheet, styleBuilder, styleBuilder.getPointConverter());
        this.processTextDecoration(styleSheet, styleBuilder);
        ElementAlignment align = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleKeys.ALIGNMENT);
        styleBuilder.append(StyleBuilder.CSSKeys.TEXT_ALIGN, RichTextHtmlStyleBuilderFactory.translateHorizontalAlignment(align));
        double wordSpacing = styleSheet.getDoubleStyleProperty(TextStyleKeys.WORD_SPACING, 0.0);
        styleBuilder.append(StyleBuilder.CSSKeys.WORD_SPACING, styleBuilder.getPointConverter().format(this.fixLengthForSafari(wordSpacing)), "pt");
        double minLetterSpacing = styleSheet.getDoubleStyleProperty(TextStyleKeys.X_MIN_LETTER_SPACING, 0.0);
        double maxLetterSpacing = styleSheet.getDoubleStyleProperty(TextStyleKeys.X_MAX_LETTER_SPACING, 0.0);
        styleBuilder.append(StyleBuilder.CSSKeys.LETTER_SPACING, styleBuilder.getPointConverter().format(this.fixLengthForSafari(Math.min(minLetterSpacing, maxLetterSpacing))), "pt");
        this.processWhiteSpaceCollapse(styleSheet, styleBuilder);
        return styleBuilder;
    }

    private void processWhiteSpaceCollapse(StyleSheet styleSheet, DefaultStyleBuilder filterStyleBuilder) {
        WhitespaceCollapse wsCollapse = (WhitespaceCollapse)styleSheet.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (WhitespaceCollapse.PRESERVE.equals(wsCollapse)) {
            if (this.useWhitespacePreWrap) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "pre-wrap");
            } else {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "pre");
            }
        } else if (WhitespaceCollapse.PRESERVE_BREAKS.equals(wsCollapse)) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "nowrap");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.WHITE_SPACE, "normal");
        }
    }

    private void processFontStyle(StyleSheet styleSheet, DefaultStyleBuilder filterStyleBuilder, NumberFormat pointConverter) {
        filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.FONT_FAMILY, RichTextHtmlStyleBuilderFactory.translateFontFamily(styleSheet));
        filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_SIZE, pointConverter.format(this.fixLengthForSafari(styleSheet.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, 0.0))), "pt");
        if (styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD)) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_WEIGHT, "bold");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_WEIGHT, "normal");
        }
        if (styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC)) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_STYLE, "italic");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.FONT_STYLE, "normal");
        }
    }

    private void processTextDecoration(StyleSheet styleSheet, DefaultStyleBuilder filterStyleBuilder) {
        boolean underlined = styleSheet.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
        boolean strikeThrough = styleSheet.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
        if (underlined && strikeThrough) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "underline line-through");
        } else if (strikeThrough) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "line-through");
        } else if (underlined) {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "underline");
        } else {
            filterStyleBuilder.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "none");
        }
    }

    private void processBorder(StyleSheet styleSheet, BoxDefinition boxDefinition, FilterStyleBuilder filterStyleBuilder, NumberFormat pointConverter) {
        Border border = boxDefinition.getBorder();
        BorderEdge top = border.getTop();
        BorderEdge left = border.getLeft();
        BorderEdge bottom = border.getBottom();
        BorderEdge right = border.getRight();
        if (top.equals(left) && top.equals(right) && top.equals(bottom)) {
            if (!BorderEdge.EMPTY.equals(top)) {
                filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER, filterStyleBuilder.printEdgeAsCSS(top));
            }
        } else {
            if (top != null && !BorderEdge.EMPTY.equals(top)) {
                filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_TOP, filterStyleBuilder.printEdgeAsCSS(top));
            }
            if (left != null && !BorderEdge.EMPTY.equals(left)) {
                filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_LEFT, filterStyleBuilder.printEdgeAsCSS(left));
            }
            if (bottom != null && !BorderEdge.EMPTY.equals(bottom)) {
                filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_BOTTOM, filterStyleBuilder.printEdgeAsCSS(bottom));
            }
            if (right != null && !BorderEdge.EMPTY.equals(right)) {
                filterStyleBuilder.appendRaw(StyleBuilder.CSSKeys.BORDER_RIGHT, filterStyleBuilder.printEdgeAsCSS(right));
            }
        }
        if (this.enableRoundBorderCorner) {
            double blW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, 0.0));
            double blH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, 0.0));
            if (blW > 0.0 && blH > 0.0) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_BOTTOM_LEFT, pointConverter.format(this.fixLengthForSafari(blW)) + "pt " + pointConverter.format(this.fixLengthForSafari(blH)) + "pt");
                filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_BOTTOM_LEFT_RADIUS, pointConverter.format(this.fixLengthForSafari(blW)) + "pt " + pointConverter.format(this.fixLengthForSafari(blH)) + "pt");
            }
            double brW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, 0.0));
            double brH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, 0.0));
            if (brW > 0.0 && brH > 0.0) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_BOTTOM_RIGHT, pointConverter.format(this.fixLengthForSafari(brW)) + "pt " + pointConverter.format(this.fixLengthForSafari(brH)) + "pt");
                filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_BOTTOM_RIGHT_RADIUS, pointConverter.format(this.fixLengthForSafari(brW)) + "pt " + pointConverter.format(this.fixLengthForSafari(brH)) + "pt");
            }
            double tlW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, 0.0));
            double tlH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, 0.0));
            if (tlW > 0.0 && tlH > 0.0) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_TOP_LEFT, pointConverter.format(this.fixLengthForSafari(tlW)) + "pt " + pointConverter.format(this.fixLengthForSafari(tlH)) + "pt");
                filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_TOP_LEFT_RADIUS, pointConverter.format(this.fixLengthForSafari(tlW)) + "pt " + pointConverter.format(this.fixLengthForSafari(tlH)) + "pt");
            }
            double trW = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, 0.0));
            double trH = Math.max(0.0, styleSheet.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, 0.0));
            if (trW > 0.0 && trH > 0.0) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.MOZ_BORDER_RADIUS_TOP_RIGHT, pointConverter.format(this.fixLengthForSafari(trW)) + "pt " + pointConverter.format(this.fixLengthForSafari(trH)) + "pt");
                filterStyleBuilder.append(StyleBuilder.CSSKeys.BORDER_TOP_RIGHT_RADIUS, pointConverter.format(this.fixLengthForSafari(trW)) + "pt " + pointConverter.format(this.fixLengthForSafari(trH)) + "pt");
            }
        }
        long paddingTop = boxDefinition.getPaddingTop();
        long paddingLeft = boxDefinition.getPaddingLeft();
        long paddingBottom = boxDefinition.getPaddingBottom();
        long paddingRight = boxDefinition.getPaddingRight();
        if (paddingTop == paddingLeft && paddingTop == paddingRight && paddingTop == paddingBottom) {
            if (paddingTop > 0L) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING, pointConverter.format(this.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingTop))), "pt");
            }
        } else {
            if (paddingTop > 0L) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_TOP, pointConverter.format(this.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingTop))), "pt");
            }
            if (paddingLeft > 0L) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_LEFT, pointConverter.format(this.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingLeft))), "pt");
            }
            if (paddingBottom > 0L) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_BOTTOM, pointConverter.format(this.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingBottom))), "pt");
            }
            if (paddingRight > 0L) {
                filterStyleBuilder.append(StyleBuilder.CSSKeys.PADDING_RIGHT, pointConverter.format(this.fixLengthForSafari(StrictGeomUtility.toExternalValue(paddingRight))), "pt");
            }
        }
    }

    private static String translateFontFamily(StyleSheet box) {
        String family = (String)box.getStyleProperty(TextStyleKeys.FONT);
        if ("Serif".equalsIgnoreCase(family)) {
            return "serif";
        }
        if ("Sans-serif".equalsIgnoreCase(family) || "SanSerif".equalsIgnoreCase(family) || "SansSerif".equalsIgnoreCase(family) || "Dialog".equalsIgnoreCase(family) || "DialogInput".equalsIgnoreCase(family)) {
            return "sans-serif";
        }
        if ("Monospaced".equalsIgnoreCase(family)) {
            return "monospace";
        }
        return '\"' + HtmlEncoderUtil.encodeCSS(family) + '\"';
    }

    public double fixLengthForSafari(double border) {
        if (!this.safariLengthFix) {
            return border;
        }
        if (border == 0.0) {
            return 0.0;
        }
        return Math.max(1L, Math.round(border));
    }

    public static String translateHorizontalAlignment(ElementAlignment ea) {
        if (ElementAlignment.JUSTIFY.equals(ea)) {
            return "justify";
        }
        if (ElementAlignment.RIGHT.equals(ea)) {
            return "right";
        }
        if (ElementAlignment.CENTER.equals(ea)) {
            return "center";
        }
        return "left";
    }

    public void configure(Configuration configuration) {
        this.safariLengthFix = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.SafariLengthHack"));
        this.useWhitespacePreWrap = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.UseWhitespacePreWrap"));
        this.enableRoundBorderCorner = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.EnableRoundBorderCorner"));
    }
}

