/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.valign;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.AlignContext;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;

public final class InlineBlockAlignContext
extends AlignContext {
    private long[] baselines;
    private long baselineShift;

    public InlineBlockAlignContext(RenderBox box) {
        super(box);
        ExtendedBaselineInfo baselineInfo = box.getBaselineInfo();
        this.baselines = baselineInfo.getBaselines();
        this.setDominantBaseline(baselineInfo.getDominantBaseline());
    }

    @Override
    public long getBaselineDistance(int baseline) {
        return this.baselines[baseline] - this.baselines[this.getDominantBaseline()] + this.baselineShift;
    }

    @Override
    public void shift(long delta) {
        this.baselineShift += delta;
    }

    @Override
    public long getAfterEdge() {
        return this.baselines[9] + this.baselineShift;
    }

    @Override
    public long getBeforeEdge() {
        return this.baselines[0] + this.baselineShift;
    }
}

