/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.util.OrphanContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;
import org.pentaho.reporting.engine.classic.core.util.RingBuffer;

public class OrphanBlockContext
implements OrphanContext {
    private static final Log logger = LogFactory.getLog(OrphanBlockContext.class);
    private StackedObjectPool<OrphanBlockContext> pool;
    private OrphanContext parent;
    private RenderBox contextBox;
    private int orphans;
    private int orphanCount;
    private RingBuffer<RenderNode> orphanSize;
    private long orphanOverride;
    private RenderNode currentNode;
    private boolean breakMarkerSeen;

    public void init(StackedObjectPool<OrphanBlockContext> pool, OrphanContext parent, RenderBox contextBox, int orphans) {
        this.breakMarkerSeen = false;
        this.pool = pool;
        this.parent = parent;
        this.contextBox = contextBox;
        this.orphans = orphans;
        this.orphanOverride = contextBox.getCachedY();
        this.orphanCount = 0;
        if (orphans > 0) {
            if (this.orphanSize == null) {
                this.orphanSize = new RingBuffer(orphans);
            } else {
                this.orphanSize.resize(orphans);
            }
        }
    }

    @Override
    public void startChild(RenderBox box) {
        this.currentNode = box;
        if (this.parent != null) {
            this.parent.startChild(box);
        }
    }

    @Override
    public void endChild(RenderBox box) {
        if (this.currentNode != null) {
            if (this.orphanCount < this.orphans && this.orphans > 0) {
                this.orphanSize.add(box);
                box.setRestrictFinishedClearOut(RenderBox.RestrictFinishClearOut.LEAF);
            }
            ++this.orphanCount;
            this.currentNode = null;
        }
        if (this.parent != null) {
            this.parent.endChild(box);
        }
    }

    @Override
    public void registerFinishedNode(FinishedRenderNode box) {
        if (this.orphanCount < this.orphans && this.orphans > 0) {
            this.orphanSize.add(box);
            box.getParent().setRestrictFinishedClearOut(RenderBox.RestrictFinishClearOut.RESTRICTED);
        }
        this.orphanCount += box.getOrphanLeafCount();
        this.currentNode = null;
        if (this.parent != null) {
            this.parent.registerFinishedNode(box);
        }
    }

    @Override
    public void registerBreakMark(RenderBox box) {
        this.breakMarkerSeen = true;
        if (this.parent != null) {
            this.parent.registerBreakMark(box);
        }
    }

    @Override
    public long getOrphanValue() {
        if (this.orphans == 0) {
            return this.orphanOverride;
        }
        RenderNode lastValue = this.orphanSize.getLastValue();
        if (lastValue == null) {
            return this.orphanOverride;
        }
        return Math.max(this.orphanOverride, lastValue.getCachedY2());
    }

    @Override
    public OrphanContext commit(RenderBox box) {
        boolean incomplete;
        boolean keepTogether = box.getStaticBoxLayoutProperties().isAvoidPagebreakInside();
        long constraintSize = keepTogether ? Math.max(this.getOrphanValue(), box.getCachedY() + box.getCachedHeight()) : this.getOrphanValue();
        box.setOrphanConstraintSize(Math.max(0L, constraintSize - box.getCachedY()));
        box.setOrphanLeafCount(this.orphanCount);
        boolean bl = incomplete = box.isOpen() || box.getContentRefCount() > 0;
        if (!this.breakMarkerSeen && incomplete) {
            if (this.orphanCount < this.orphans || keepTogether) {
                box.setInvalidWidowOrphanNode(true);
            } else {
                box.setInvalidWidowOrphanNode(false);
            }
        } else {
            box.setInvalidWidowOrphanNode(false);
        }
        if (this.parent != null) {
            this.parent.subContextCommitted(box);
        }
        return this.parent;
    }

    @Override
    public void subContextCommitted(RenderBox contextBox) {
        long cachedY = contextBox.getCachedY();
        if (cachedY < this.getOrphanValue() || cachedY == this.contextBox.getCachedY() && cachedY == this.getOrphanValue()) {
            this.orphanOverride = Math.max(this.orphanOverride, cachedY + contextBox.getOrphanConstraintSize());
        }
        if (this.parent != null) {
            this.parent.subContextCommitted(contextBox);
        }
    }

    @Override
    public void clearForPooledReuse() {
        this.parent = null;
        this.contextBox = null;
        this.pool.free(this);
    }
}

