/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.linebreak.EmptyLinebreaker;
import org.pentaho.reporting.engine.classic.core.layout.process.linebreak.FullLinebreaker;
import org.pentaho.reporting.engine.classic.core.layout.process.linebreak.ParagraphLinebreaker;
import org.pentaho.reporting.engine.classic.core.layout.process.linebreak.SimpleLinebreaker;
import org.pentaho.reporting.libraries.base.util.FastStack;

public final class ParagraphLineBreakStep
extends IterateStructuralProcessStep {
    private static final EmptyLinebreaker LEAF_BREAK_STATE = new EmptyLinebreaker();
    private FastStack<ParagraphLinebreaker> paragraphNesting = new FastStack(50);
    private ParagraphLinebreaker breakState;
    private SimpleLinebreaker reusableSimpleLinebreaker;

    public void compute(LogicalPageBox root) {
        this.paragraphNesting.clear();
        try {
            this.startProcessing(root);
        }
        finally {
            this.paragraphNesting.clear();
            this.breakState = null;
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        super.processParagraphChilds(box);
    }

    @Override
    protected void processRenderableContent(RenderableReplacedContentBox box) {
        if (this.breakState != null) {
            this.breakState.addNode(box);
        }
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        if (box.getNodeType() == 274) {
            boolean unchanged;
            ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
            long poolChangeTracker = paragraphBox.getPool().getChangeTracker();
            boolean bl = unchanged = poolChangeTracker == paragraphBox.getLineBoxAge();
            if (unchanged || paragraphBox.getPool().getFirstChild() == null) {
                this.paragraphNesting.push((Object)LEAF_BREAK_STATE);
                this.breakState = LEAF_BREAK_STATE;
                return false;
            }
            if (this.breakState == null) {
                ParagraphPoolBox paragraphPoolBox = paragraphBox.getPool();
                RenderNode firstChild = paragraphPoolBox.getFirstChild();
                if (firstChild == null) {
                    paragraphBox.setPoolSize(0);
                    paragraphBox.setLineBoxAge(paragraphPoolBox.getChangeTracker());
                    this.breakState = LEAF_BREAK_STATE;
                    return false;
                }
                if (firstChild == paragraphPoolBox.getLastChild() && (firstChild.getLayoutNodeType() & 2) != 2) {
                    paragraphBox.setPoolSize(1);
                    paragraphBox.setLineBoxAge(paragraphPoolBox.getChangeTracker());
                    this.breakState = LEAF_BREAK_STATE;
                    return false;
                }
                if (paragraphBox.isComplexParagraph()) {
                    FullLinebreaker item = new FullLinebreaker(paragraphBox);
                    this.paragraphNesting.push((Object)item);
                    this.breakState = item;
                } else {
                    if (this.reusableSimpleLinebreaker == null) {
                        this.reusableSimpleLinebreaker = new SimpleLinebreaker(paragraphBox);
                    } else {
                        this.reusableSimpleLinebreaker.recycle(paragraphBox);
                    }
                    this.paragraphNesting.push((Object)this.reusableSimpleLinebreaker);
                    this.breakState = this.reusableSimpleLinebreaker;
                }
                return true;
            }
            if (!this.breakState.isWritable()) {
                throw new IllegalStateException("A child cannot be dirty, if the parent is clean");
            }
            if (!(this.breakState instanceof FullLinebreaker)) {
                FullLinebreaker fullBreaker = this.breakState.startComplexLayout();
                this.paragraphNesting.pop();
                this.paragraphNesting.push((Object)fullBreaker);
                this.breakState = fullBreaker;
            }
            ParagraphLinebreaker subFlow = this.breakState.startParagraphBox(paragraphBox);
            this.paragraphNesting.push((Object)subFlow);
            this.breakState = subFlow;
            return true;
        }
        if (this.breakState == null) {
            return !box.isLinebreakCacheValid();
        }
        if (!this.breakState.isWritable()) {
            throw new IllegalStateException("This cannot be: There is an active break-state, but the box is not writable.");
        }
        this.breakState.startBlockBox(box);
        return true;
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        box.setLinebreakAge(box.getChangeTracker());
        if (box.getNodeType() == 274) {
            if (this.breakState == LEAF_BREAK_STATE && this.paragraphNesting.isEmpty()) {
                this.breakState = null;
                return;
            }
            this.breakState.finish();
            this.paragraphNesting.pop();
            if (this.paragraphNesting.isEmpty()) {
                if (this.reusableSimpleLinebreaker != null) {
                    this.reusableSimpleLinebreaker.dispose();
                }
                this.breakState = null;
            } else {
                this.breakState = (ParagraphLinebreaker)this.paragraphNesting.peek();
                this.breakState.finishParagraphBox((ParagraphRenderBox)box);
            }
            return;
        }
        if (this.breakState == null) {
            return;
        }
        if (!this.breakState.isWritable()) {
            throw new IllegalStateException("A child cannot be dirty, if the parent is clean");
        }
        this.breakState.finishBlockBox(box);
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected void finishCanvasBox(CanvasRenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        if (this.breakState == null || !this.breakState.isWritable()) {
            return !box.isLinebreakCacheValid();
        }
        this.breakState.startInlineBox(box);
        return true;
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        box.setLinebreakAge(box.getChangeTracker());
        if (this.breakState == null || !this.breakState.isWritable()) {
            return;
        }
        this.breakState.finishInlineBox(box);
        if (this.breakState.isBreakRequested() && !this.isEndOfLine(box)) {
            this.performBreak();
        }
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected void finishRowBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected void finishTableRowBox(TableRowRenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        this.finishBox(box);
    }

    private void finishBox(RenderBox box) {
        box.setLinebreakAge(box.getChangeTracker());
        if (this.breakState == null) {
            return;
        }
        if (!this.breakState.isWritable()) {
            throw new IllegalStateException("A child cannot be dirty, if the parent is clean");
        }
        this.breakState.finishBlockBox(box);
    }

    private boolean startBox(RenderBox box) {
        if (this.breakState == null) {
            return !box.isLinebreakCacheValid();
        }
        if (!this.breakState.isWritable()) {
            throw new IllegalStateException("A child cannot be dirty, if the parent is clean");
        }
        this.breakState.startBlockBox(box);
        return true;
    }

    private void processText(RenderableText text) {
        this.breakState.addNode(text);
        if (!text.isForceLinebreak()) {
            return;
        }
        if (this.breakState.isBreakRequested()) {
            this.performBreak();
        }
        if (text.getNext() == null) {
            if (this.isEndOfLine(text)) {
                return;
            }
            this.breakState.setBreakRequested(true);
            return;
        }
        this.performBreak();
    }

    private void processText(RenderableComplexText text) {
        this.breakState.addNode(text);
        if (!text.isForceLinebreak()) {
            return;
        }
        if (this.breakState.isBreakRequested()) {
            this.performBreak();
        }
        if (text.getNext() == null) {
            if (this.isEndOfLine(text)) {
                return;
            }
            this.breakState.setBreakRequested(true);
            return;
        }
        this.performBreak();
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        if (this.breakState == null || !this.breakState.isWritable()) {
            return;
        }
        if (this.breakState.isSuspended()) {
            this.breakState.addNode(node);
        } else if (node.getNodeType() == 17) {
            RenderableText text = (RenderableText)node;
            this.processText(text);
        } else if (node.getNodeType() == 273) {
            RenderableComplexText text = (RenderableComplexText)node;
            this.processText(text);
        } else {
            this.breakState.addNode(node);
        }
    }

    private boolean isEndOfLine(RenderNode node) {
        while (node != null) {
            int nodeType = node.getLayoutNodeType();
            if ((nodeType & 2) == 2 && (nodeType & 0x42) != 66) {
                return true;
            }
            if (node.getNext() != null) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    private void performBreak() {
        if (!(this.breakState instanceof FullLinebreaker)) {
            FullLinebreaker fullBreaker = this.breakState.startComplexLayout();
            this.paragraphNesting.pop();
            this.paragraphNesting.push((Object)fullBreaker);
            this.breakState = fullBreaker;
            fullBreaker.performBreak();
        } else {
            FullLinebreaker fullBreaker = (FullLinebreaker)this.breakState;
            fullBreaker.performBreak();
        }
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        if (this.breakState == null) {
            return !box.isLinebreakCacheValid();
        }
        if (!this.breakState.isWritable()) {
            return false;
        }
        this.breakState.startBlockBox(box);
        return true;
    }

    @Override
    protected void finishOtherBox(RenderBox box) {
        box.setLinebreakAge(box.getChangeTracker());
        if (this.breakState != null && this.breakState.isWritable()) {
            this.breakState.finishBlockBox(box);
        }
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        if (this.breakState == null) {
            return !box.isLinebreakCacheValid();
        }
        if (!this.breakState.isWritable()) {
            return false;
        }
        this.breakState.startBlockBox(box);
        return true;
    }

    @Override
    protected void finishTableCellBox(TableCellRenderBox box) {
        box.setLinebreakAge(box.getChangeTracker());
        if (this.breakState != null && this.breakState.isWritable()) {
            this.breakState.finishBlockBox(box);
        }
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return false;
    }

    @Override
    protected boolean startTableBox(TableRenderBox box) {
        if (this.breakState == null) {
            return !box.isLinebreakCacheValid();
        }
        if (!this.breakState.isWritable()) {
            return false;
        }
        this.breakState.startBlockBox(box);
        return true;
    }

    @Override
    protected void finishTableBox(TableRenderBox box) {
        box.setLinebreakAge(box.getChangeTracker());
        if (this.breakState != null && this.breakState.isWritable()) {
            this.breakState.finishBlockBox(box);
        }
    }
}

