/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output.crosstab;

import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabDetailMode;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.CrosstabOutputHelper;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.RenderedCrosstabLayout;

public class CrosstabColumnOutputHandler
implements GroupOutputHandler {
    @Override
    public void groupStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        int gidx = event.getState().getCurrentGroupIndex();
        CrosstabColumnGroup group = (CrosstabColumnGroup)event.getReport().getGroup(gidx);
        if (crosstabLayout.getFirstColGroupIndex() == -1) {
            crosstabLayout.setFirstColGroupIndex(gidx);
        }
        if (!crosstabLayout.isCrosstabHeaderOpen()) {
            return;
        }
        this.expandColumnSpanAfterRowStart(crosstabLayout, layoutModelBuilder, gidx);
        if (crosstabLayout.isGenerateColumnTitleHeaders()) {
            layoutModelBuilder.startSubFlow(crosstabLayout.getColumnTitleHeaderSubflowId(gidx));
            CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
            crosstabLayout.setColumnTitleHeaderCellId(gidx - crosstabLayout.getFirstColGroupIndex(), layoutModelBuilder.dangerousRawAccess().getInstanceId());
            outputFunction.getRenderer().add(group.getTitleHeader(), outputFunction.getRuntime());
            layoutModelBuilder.finishBox();
            layoutModelBuilder.suspendSubFlow();
        }
        layoutModelBuilder.startSubFlow(crosstabLayout.getColumnHeaderSubflowId(gidx));
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
        crosstabLayout.setColumnHeaderCellId(gidx - crosstabLayout.getFirstColGroupIndex(), layoutModelBuilder.dangerousRawAccess().getInstanceId());
        outputFunction.getRenderer().add(group.getHeader(), outputFunction.getRuntime());
        layoutModelBuilder.finishBox();
        layoutModelBuilder.suspendSubFlow();
    }

    private void expandColumnSpanAfterRowStart(RenderedCrosstabLayout crosstabLayout, LayoutModelBuilder layoutModelBuilder, int gidx) {
        if (!crosstabLayout.isProcessingCrosstabHeader()) {
            crosstabLayout.setProcessingCrosstabHeader(true);
            CrosstabOutputHelper.expandColumnHeaderSpan(crosstabLayout, layoutModelBuilder, gidx);
        }
    }

    @Override
    public void groupFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        if (CrosstabOutputHelper.isLastColumnGroup(event)) {
            return;
        }
        CrosstabOutputHelper.printCrosstabSummary(outputFunction, event);
    }

    @Override
    public void groupBodyFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }

    @Override
    public void itemsStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        this.generateMeasureHeader(outputFunction, event);
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
        layoutModelBuilder.legacyFlagNotEmpty();
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        crosstabLayout.setDetailsRendered(false);
        crosstabLayout.setProcessingCrosstabHeader(false);
    }

    private void generateMeasureHeader(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        if (!crosstabLayout.isCrosstabHeaderOpen()) {
            return;
        }
        if (!crosstabLayout.isGenerateMeasureHeaders()) {
            return;
        }
        CrosstabCellBody dataBody = event.getReport().getCrosstabCellBody();
        if (dataBody == null) {
            throw new InvalidReportStateException();
        }
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        layoutModelBuilder.startSubFlow(crosstabLayout.getMeasureHeaderSubflowId());
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
        outputFunction.getRenderer().add(dataBody.getHeader(), outputFunction.getRuntime());
        layoutModelBuilder.finishBox();
        layoutModelBuilder.suspendSubFlow();
    }

    @Override
    public void itemsAdvanced(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        CrosstabCellBody dataBody = event.getReport().getCrosstabCellBody();
        if (dataBody == null) {
            return;
        }
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        if (crosstabLayout.isDetailsRendered()) {
            return;
        }
        CrosstabCell element = dataBody.findElement(null, null);
        if (element != null) {
            CrosstabDetailMode detailMode = crosstabLayout.getDetailMode();
            if (detailMode == null) {
                throw new IllegalStateException();
            }
            if (CrosstabDetailMode.last.equals((Object)detailMode)) {
                crosstabLayout.setDetailsRendered(true);
                return;
            }
            outputFunction.getRenderer().startSection(Renderer.SectionType.NORMALFLOW);
            outputFunction.getRenderer().add(element, outputFunction.getRuntime());
            outputFunction.addSubReportMarkers(outputFunction.getRenderer().endSection());
            if (CrosstabDetailMode.first.equals((Object)detailMode)) {
                crosstabLayout.setDetailsRendered(true);
            }
        }
    }

    @Override
    public void itemsFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        CrosstabCellBody dataBody;
        CrosstabCell element;
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        if (CrosstabDetailMode.last.equals((Object)crosstabLayout.getDetailMode()) && (element = (dataBody = event.getReport().getCrosstabCellBody()).findElement(null, null)) != null) {
            outputFunction.getRenderer().startSection(Renderer.SectionType.NORMALFLOW);
            outputFunction.getRenderer().add(element, outputFunction.getRuntime());
            outputFunction.addSubReportMarkers(outputFunction.getRenderer().endSection());
        }
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        layoutModelBuilder.finishBox();
    }

    @Override
    public void summaryRowStart(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("Crosstab-column groups handler cannot contain summary-rows");
    }

    @Override
    public void summaryRowEnd(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("Crosstab-column groups handler cannot contain summary-rows");
    }

    @Override
    public void summaryRow(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("Crosstab-column groups handler cannot contain summary-rows");
    }
}

