/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.AbstractRowModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRow;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowImpl;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class SeparateRowModel
extends AbstractRowModel {
    private static final Log logger = LogFactory.getLog(SeparateRowModel.class);
    private int validatedRowCount;
    private int validatedActualSizes;
    private long rowSpacing;

    @Override
    public long getRowSpacing() {
        return this.rowSpacing;
    }

    public void setRowSpacing(long rowSpacing) {
        this.rowSpacing = rowSpacing;
    }

    @Override
    public void initialize(TableRenderBox table) {
        this.rowSpacing = table.getRowSpacing().resolve(0L);
    }

    private ProcessedRowVoter compute(long[] preferredSizes, int validatedRowCount, RowProcessingDelegate delegate) {
        int rowCount = this.getRowCount();
        ProcessedRowVoter voter = new ProcessedRowVoter(rowCount, validatedRowCount);
        if (preferredSizes.length == 0) {
            return voter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Computing: " + (rowCount - validatedRowCount) + " rows. " + validatedRowCount));
        }
        int currentRowSpan = 0;
        boolean processNextLevel = true;
        while (processNextLevel) {
            ++currentRowSpan;
            processNextLevel = false;
            for (int rowIdx = validatedRowCount; rowIdx < rowCount; ++rowIdx) {
                TableRow row = this.getRow(rowIdx);
                int maximumRowSpan = row.getMaximumRowSpan();
                if (maximumRowSpan < currentRowSpan) continue;
                long preferredSize = delegate.run(row, currentRowSpan);
                this.distribute(preferredSize, preferredSizes, rowIdx, currentRowSpan);
                if (maximumRowSpan > currentRowSpan) {
                    processNextLevel = true;
                }
                if (rowIdx + currentRowSpan <= rowCount) {
                    voter.accept(rowIdx + currentRowSpan);
                    continue;
                }
                voter.reject(rowIdx);
            }
        }
        return voter;
    }

    @Override
    public void validatePreferredSizes() {
        int rowCount = this.getRowCount();
        if (this.validatedRowCount == rowCount) {
            return;
        }
        long[] preferredSizes = this.getPreferredSizes(this.validatedRowCount);
        ProcessedRowVoter voter = this.compute(preferredSizes, this.validatedRowCount, new RowProcessingDelegate(){

            @Override
            public long run(TableRow r, int rowSpan) {
                return r.getPreferredSize(rowSpan);
            }
        });
        this.applyPreferredSizes(preferredSizes, this.validatedRowCount, rowCount);
        this.validatedRowCount = voter.getProcessedRows();
    }

    @Override
    public void validateActualSizes() {
        this.validatePreferredSizes();
        int rowCount = this.getRowCount();
        if (this.validatedActualSizes == rowCount) {
            return;
        }
        long[] trailingSizes = this.getValidateSizes(this.validatedActualSizes);
        ProcessedRowVoter voter = this.compute(trailingSizes, this.validatedActualSizes, new RowProcessingDelegate(){

            @Override
            public long run(TableRow r, int rowSpan) {
                return r.getValidatedTrailingSize(rowSpan);
            }
        });
        this.applyValidateSizes(trailingSizes, this.validatedActualSizes, rowCount);
        this.validatedActualSizes = voter.getProcessedRows();
    }

    private void distribute(long usedSpace, long[] allSpaces, int colIdx, int colspanX) {
        int maxColspan = Math.min(colIdx + colspanX, allSpaces.length) - colIdx;
        long usedPrev = 0L;
        int maxSize = Math.min(allSpaces.length, colIdx + maxColspan);
        for (int i = colIdx; i < maxSize; ++i) {
            usedPrev += allSpaces[i];
        }
        if (usedSpace <= usedPrev) {
            return;
        }
        long distSpace = usedSpace - usedPrev;
        long delta = distSpace / (long)maxColspan;
        for (int i = 0; i < maxColspan - 1; ++i) {
            int n = colIdx + i;
            allSpaces[n] = allSpaces[n] + delta;
        }
        int n = colIdx + maxColspan - 1;
        allSpaces[n] = allSpaces[n] + (distSpace - (long)(maxColspan - 1) * delta);
    }

    @Override
    public void clear() {
        this.validatedActualSizes = 0;
        this.validatedRowCount = 0;
        for (TableRowImpl row : this.getRows()) {
            row.clear();
        }
    }

    public int getValidatedRowCount() {
        return this.validatedRowCount;
    }

    public int getValidatedActualSizes() {
        return this.validatedActualSizes;
    }

    @Override
    public void prune(int rows) {
        super.prune(rows);
        if (rows <= 1) {
            return;
        }
        this.validatedActualSizes -= rows;
        this.validatedRowCount -= rows;
    }

    @Override
    public void setDebugInformation(ElementType elementType, InstanceID instanceID) {
    }

    public String toString() {
        TableRowImpl[] rows = this.getRows();
        StringBuilder b = new StringBuilder();
        for (TableRowImpl r : rows) {
            b.append(r);
            b.append("\n");
        }
        return "SeparateRowModel{rows=\n" + b + ", rowSpacing=" + this.rowSpacing + ", validatedActualSizes=" + this.validatedActualSizes + ", validatedRowCount=" + this.validatedRowCount + '}';
    }

    private static interface RowProcessingDelegate {
        public long run(TableRow var1, int var2);
    }

    private static class ProcessedRowVoter {
        private int rejectedRow;
        private int acceptedRow;

        private ProcessedRowVoter(int rowCount, int previouslyProcessedRows) {
            this.rejectedRow = rowCount;
            this.acceptedRow = previouslyProcessedRows;
        }

        public void reject(int row) {
            this.rejectedRow = Math.min(row, this.rejectedRow);
        }

        public void accept(int row) {
            this.acceptedRow = Math.max(row, this.acceptedRow);
        }

        public int getProcessedRows() {
            return Math.min(this.rejectedRow, this.acceptedRow);
        }
    }
}

