/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.columns;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumn;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnGroup;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;

public abstract class AbstractColumnModel
implements TableColumnModel {
    private static final Log logger = LogFactory.getLog(AbstractColumnModel.class);
    private boolean validated;
    private ArrayList<TableColumnGroup> columnGroups = new ArrayList();
    private TableColumn[] columns = null;

    @Override
    public void addColumnGroup(TableColumnGroup column) {
        this.columnGroups.add(column);
        column.freeze();
        this.validated = false;
    }

    @Override
    public void addAutoColumn() {
        TableColumnGroup autoGroup = new TableColumnGroup();
        TableColumn column = new TableColumn(Border.EMPTY_BORDER, RenderLength.AUTO, true);
        autoGroup.addColumn(column);
        autoGroup.freeze();
        this.columnGroups.add(autoGroup);
        this.validated = false;
    }

    @Override
    public boolean isIncrementalModeSupported() {
        return true;
    }

    public int getColumnGroupCount() {
        return this.columnGroups.size();
    }

    @Override
    public int getColumnCount() {
        this.buildColumns();
        return this.columns.length;
    }

    private void buildColumns() {
        if (this.validated) {
            return;
        }
        ArrayList<TableColumn> cols = new ArrayList<TableColumn>();
        for (int i = 0; i < this.columnGroups.size(); ++i) {
            TableColumnGroup node = this.columnGroups.get(i);
            int count = node.getColumnCount();
            for (int x = 0; x < count; ++x) {
                TableColumn column = node.getColumn(x);
                cols.add(column);
            }
        }
        this.columns = cols.toArray(new TableColumn[cols.size()]);
        this.validated = true;
    }

    public TableColumnGroup getColumnGroup(int i) {
        return this.columnGroups.get(i);
    }

    public TableColumn getColumn(int i) {
        this.buildColumns();
        if (i >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.columns[i];
    }

    public TableColumn[] getColumns() {
        this.buildColumns();
        return this.columns;
    }

    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public long getBorderSpacing() {
        return 0L;
    }

    public TableColumnGroup getGroupForIndex(int idx) {
        int offset = 0;
        for (int j = 0; j < this.columnGroups.size(); ++j) {
            TableColumnGroup group = this.columnGroups.get(j);
            if (offset + group.getColumnCount() <= idx) {
                offset += group.getColumnCount();
                continue;
            }
            return group;
        }
        throw new IndexOutOfBoundsException("No such group");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractColumnModel cm = (AbstractColumnModel)super.clone();
        cm.columns = null;
        cm.validated = false;
        cm.columnGroups = (ArrayList)this.columnGroups.clone();
        return cm;
    }

    @Override
    public void clear() {
        this.columnGroups.clear();
        this.validated = false;
        this.columns = null;
    }

    @Override
    public long getCellPosition(int columnIndex) {
        long pos = 0L;
        for (int i = 0; i < columnIndex; ++i) {
            pos += this.getColumn(i).getEffectiveSize();
        }
        return pos;
    }

    @Override
    public void updateCellSize(int columnIndex, int colSpan, long cachedWidth) {
        logger.debug((Object)("Update cell-size: " + columnIndex + ": col-span=" + colSpan + "; width=" + cachedWidth));
        this.getColumn(columnIndex).setCachedSize(colSpan, cachedWidth);
    }

    @Override
    public RenderLength getDefinedWidth(int columnIndex) {
        return this.getColumn(columnIndex).getDefinedWidth();
    }

    @Override
    public long getEffectiveColumnSize(int columnIndex) {
        return this.getColumn(columnIndex).getEffectiveSize();
    }
}

