/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.BulkArrayList;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class StateSequence<T>
implements Serializable {
    private static final int CAPACITY = 30;
    private transient BulkArrayList<ReportStateKey> stateKeys;
    private transient BulkArrayList<Sequence<T>> sequences;

    public StateSequence(int capacity) {
        this.stateKeys = new BulkArrayList(capacity);
        this.sequences = new BulkArrayList(capacity);
    }

    public StateSequence() {
        this.stateKeys = new BulkArrayList(30);
        this.sequences = new BulkArrayList(30);
    }

    public void clear() {
        this.stateKeys.clear();
        this.sequences.clear();
    }

    public void add(ReportStateKey key, Sequence<T> result) {
        this.stateKeys.add(key);
        this.sequences.add(result);
    }

    public void update(int index, ReportStateKey key, Sequence<T> result) {
        this.stateKeys.set(index, key);
        this.sequences.set(index, result);
    }

    boolean resultExists() {
        return this.sequences.size() > 0;
    }

    void updateResult(int index, Sequence<T> result) {
        this.sequences.set(index, result);
    }

    public Sequence<T> getResult(int index) {
        return this.sequences.get(index);
    }

    public BulkArrayList<ReportStateKey> getKeys() {
        return this.stateKeys;
    }

    public int getKeyIndex(ReportStateKey key) {
        if (this.stateKeys.size() == 0 || key == null) {
            return -1;
        }
        for (int j = this.stateKeys.size() - 1; j > -1; --j) {
            ReportStateKey current = this.stateKeys.get(j);
            if (current.hashCode() != key.hashCode() || !current.equals(key)) continue;
            return j;
        }
        return -1;
    }

    private Object readResolve() throws ObjectStreamException {
        this.stateKeys = new BulkArrayList(30);
        this.sequences = new BulkArrayList(30);
        return this;
    }
}

