/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;

public class EventMonitorFunction
extends AbstractFunction
implements PageEventListener {
    private static final Log logger = LogFactory.getLog(EventMonitorFunction.class);
    private transient int reportStartCount;
    private boolean deepTraversing;

    public EventMonitorFunction() {
    }

    public EventMonitorFunction(String name) {
        this.setName(name);
    }

    @Override
    public void reportStarted(ReportEvent event) {
        logger.info((Object)("Report Started: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
        ++this.reportStartCount;
        logger.info((Object)("Report Started Count: " + this.reportStartCount));
    }

    @Override
    public void reportFinished(ReportEvent event) {
        logger.info((Object)("Report Finished: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
    }

    @Override
    public void reportDone(ReportEvent event) {
        logger.info((Object)("Report Done: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
    }

    @Override
    public void pageStarted(ReportEvent event) {
        logger.info((Object)("Page Started: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
        logger.info((Object)("Page Started: " + event.getState().getProcessKey()));
    }

    @Override
    public void pageFinished(ReportEvent event) {
        logger.info((Object)("Page Finished: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
        logger.info((Object)("Page Finished: " + event.getState().getProcessKey()));
    }

    @Override
    public void groupStarted(ReportEvent event) {
        logger.info((Object)("Group Started: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
        logger.info((Object)("Group Started: " + event.getState().getCurrentGroupIndex()));
    }

    @Override
    public void groupFinished(ReportEvent event) {
        logger.info((Object)("Group Finished: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
        logger.info((Object)("Group Finished: " + event.getState().getCurrentGroupIndex()));
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        logger.info((Object)("Items Advanced: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        logger.info((Object)("Items Started: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
    }

    @Override
    public void itemsFinished(ReportEvent event) {
        logger.info((Object)("Items Finished: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        logger.info((Object)("Report Initialized: Level = " + event.getState().getLevel() + " ItemCount: " + event.getState().getCurrentRow() + " Prepare Run: " + event.getState().isPrepareRun() + " Deep-Event " + ((event.getType() & 0x4000000) != 0)));
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean isDeepTraversing() {
        return this.deepTraversing;
    }

    public void setDeepTraversing(boolean deepTraversing) {
        this.deepTraversing = deepTraversing;
    }
}

