/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.TextFieldType;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;

public class TextFieldElementFactory
extends TextElementFactory {
    private String fieldname;
    private String nullString;
    private String formula;

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    @Override
    public Element createElement() {
        Element element = new Element();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setElementType(new TextFieldType());
        if (this.getFieldname() != null) {
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", this.getFieldname());
        }
        if (this.getFormula() != null) {
            FormulaExpression formulaExpression = new FormulaExpression();
            formulaExpression.setFormula(this.getFormula());
            element.setAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", formulaExpression);
        }
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", this.getNullString());
        return element;
    }

    public static Element createStringElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, String field) {
        return TextFieldElementFactory.createStringElement(name, bounds, paint, alignment, ElementAlignment.TOP, font, nullString, field);
    }

    public static Element createStringElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, String field) {
        TextFieldElementFactory factory = new TextFieldElementFactory();
        factory.setX(new Float(bounds.getX()));
        factory.setY(new Float(bounds.getY()));
        factory.setMinimumWidth(new Float(bounds.getWidth()));
        factory.setMinimumHeight(new Float(bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(ElementFactory.getBooleanValue(font.isBold()));
            factory.setItalic(ElementFactory.getBooleanValue(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(ElementFactory.getBooleanValue(font.isUnderline()));
            factory.setStrikethrough(ElementFactory.getBooleanValue(font.isStrikeThrough()));
            factory.setEmbedFont(ElementFactory.getBooleanValue(font.isEmbeddedFont()));
        }
        factory.setFieldname(field);
        factory.setNullString(nullString);
        return factory.createElement();
    }
}

