/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.compat;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.designtime.compat.CompatibilityConverter;
import org.pentaho.reporting.engine.classic.core.designtime.compat.CompatibilityConverterRegistry;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;

public class CompatibilityUpdater
extends AbstractStructureVisitor {
    private CompatibilityConverter[] converters = CompatibilityConverterRegistry.getInstance().getConverters();
    private CompatibilityConverter currentConverter;
    private int version;

    public void performUpdate(MasterReport report) {
        Integer versionRaw = report.getCompatibilityLevel();
        this.version = versionRaw == null ? -1 : versionRaw;
        if (this.version == -1) {
            return;
        }
        this.performUpdateInternal(report);
        report.setCompatibilityLevel(null);
    }

    public void performUpdate(SubReport report) {
        ReportDefinition reportDefinition = report.getMasterReport();
        if (reportDefinition == null) {
            return;
        }
        MasterReport masterReport = (MasterReport)reportDefinition;
        Integer versionRaw = masterReport.getCompatibilityLevel();
        this.version = versionRaw == null ? -1 : versionRaw;
        if (this.version == -1) {
            return;
        }
        this.performUpdateInternal(report);
    }

    protected void performUpdateInternal(AbstractReportDefinition report) {
        for (int i = 0; i < this.converters.length; ++i) {
            CompatibilityConverter converter = this.converters[i];
            if (converter.getTargetVersion() < this.version) continue;
            this.currentConverter = converter;
            super.inspect(report);
        }
    }

    @Override
    protected void inspectElement(ReportElement element) {
        this.currentConverter.inspectElement(element);
    }

    @Override
    protected void inspectAttributeExpression(ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        this.currentConverter.inspectAttributeExpression(element, attributeNamespace, attributeName, expression, expressionMetaData);
    }

    @Override
    protected void inspectStyleExpression(ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        this.currentConverter.inspectStyleExpression(element, styleKey, expression, expressionMetaData);
    }

    @Override
    protected void inspectExpression(AbstractReportDefinition report, Expression expression) {
        this.currentConverter.inspectExpression(report, expression);
    }

    @Override
    protected void inspectParameter(AbstractReportDefinition report, ReportParameterDefinition definition, ParameterDefinitionEntry parameter) {
        this.currentConverter.inspectParameter(report, definition, parameter);
    }

    @Override
    protected void inspectDataSource(AbstractReportDefinition report, DataFactory dataFactory) {
        this.currentConverter.inspectDataSource(report, dataFactory);
    }
}

