/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.LinkedHashMap;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;

public class TableDataFactory
extends AbstractDataFactory {
    private static final long serialVersionUID = -238954878318943053L;
    private LinkedHashMap<String, TableModel> tables = new LinkedHashMap();

    public TableDataFactory() {
    }

    public TableDataFactory(String name, TableModel tableModel) {
        this();
        this.addTable(name, tableModel);
    }

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.tables.containsKey(query);
    }

    public void addTable(String name, TableModel tableModel) {
        if (tableModel == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.tables.put(name, tableModel);
    }

    public void removeTable(String name) {
        this.tables.remove(name);
    }

    public TableModel getTable(String name) {
        return this.tables.get(name);
    }

    @Override
    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        TableModel tableModel = this.tables.get(query);
        if (tableModel == null) {
            throw new ReportDataFactoryException("The specified query '" + query + "' is not recognized.");
        }
        return tableModel;
    }

    @Override
    public void close() {
    }

    @Override
    public DataFactory derive() {
        return this.clone();
    }

    @Override
    public TableDataFactory clone() {
        TableDataFactory dataFactory = (TableDataFactory)super.clone();
        dataFactory.tables = (LinkedHashMap)this.tables.clone();
        return dataFactory;
    }

    @Override
    public String[] getQueryNames() {
        return this.tables.keySet().toArray(new String[this.tables.size()]);
    }
}

