/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.RootLevelBandDefaultStyleSheet;

public abstract class AbstractRootLevelBand
extends Band
implements RootLevelBand {
    private static final SubReport[] EMPTY_SUBREPORTS = new SubReport[0];
    private ArrayList<SubReport> subReports;

    protected AbstractRootLevelBand() {
    }

    protected AbstractRootLevelBand(boolean pagebreakBefore, boolean pagebreakAfter) {
        super(pagebreakBefore, pagebreakAfter);
    }

    @Override
    public int getSubReportCount() {
        if (this.subReports == null) {
            return 0;
        }
        return this.subReports.size();
    }

    @Override
    public AbstractRootLevelBand clone() {
        AbstractRootLevelBand rootLevelBand = (AbstractRootLevelBand)super.clone();
        if (rootLevelBand.subReports != null) {
            rootLevelBand.subReports = (ArrayList)rootLevelBand.subReports.clone();
            rootLevelBand.subReports.clear();
            for (int i = 0; i < this.subReports.size(); ++i) {
                SubReport report = this.subReports.get(i);
                SubReport clone = report.clone();
                clone.setParent(rootLevelBand);
                rootLevelBand.subReports.add(clone);
            }
        }
        return rootLevelBand;
    }

    @Override
    public AbstractRootLevelBand derive(boolean preserveElementInstanceIds) {
        AbstractRootLevelBand rootLevelBand = (AbstractRootLevelBand)super.derive(preserveElementInstanceIds);
        if (rootLevelBand.subReports != null) {
            rootLevelBand.subReports = (ArrayList)rootLevelBand.subReports.clone();
            rootLevelBand.subReports.clear();
            for (int i = 0; i < this.subReports.size(); ++i) {
                SubReport report = this.subReports.get(i);
                SubReport clone = report.derive(preserveElementInstanceIds);
                clone.setParent(rootLevelBand);
                rootLevelBand.subReports.add(clone);
            }
        }
        return rootLevelBand;
    }

    @Override
    public SubReport getSubReport(int index) {
        if (this.subReports == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.subReports.get(index);
    }

    public void addSubReport(int index, SubReport element) {
        if (element == null) {
            throw new NullPointerException("Parameter 'report' must not be null");
        }
        this.validateLooping(element);
        if (this.unregisterParent(element)) {
            return;
        }
        if (this.subReports == null) {
            this.subReports = new ArrayList();
        }
        this.subReports.add(index, element);
        this.registerAsChild(element);
        this.notifyNodeChildAdded(element);
    }

    public void addSubReport(SubReport element) {
        if (element == null) {
            throw new NullPointerException("Parameter 'report' must not be null");
        }
        this.validateLooping(element);
        if (this.unregisterParent(element)) {
            return;
        }
        if (this.subReports == null) {
            this.subReports = new ArrayList();
        }
        this.subReports.add(element);
        this.registerAsChild(element);
        this.notifyNodeChildAdded(element);
    }

    public void removeSubreport(SubReport e) {
        if (e == null) {
            throw new NullPointerException("Parameter 'report' must not be null");
        }
        if (this.subReports == null) {
            return;
        }
        if (e.getParentSection() != this) {
            return;
        }
        if (!this.subReports.contains(e)) {
            return;
        }
        e.setParent(null);
        this.subReports.remove(e);
        this.notifyNodeChildRemoved(e);
    }

    @Override
    public SubReport[] getSubReports() {
        if (this.subReports == null) {
            return EMPTY_SUBREPORTS;
        }
        return this.subReports.toArray(new SubReport[this.subReports.size()]);
    }

    @Override
    public ElementStyleSheet getDefaultStyleSheet() {
        return RootLevelBandDefaultStyleSheet.getRootLevelBandDefaultStyle();
    }
}

