/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata.writer;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataEntryWriteHandler;

public class BundleMetaDataWriteHandlerFactory {
    private HashMap<String, String> defaultDefinitions = new HashMap();
    private HashMap<TagDefinitionKey, String> tagData = new HashMap();
    private String defaultNamespace;

    protected BundleMetaDataWriteHandlerFactory() {
    }

    public void configure(Configuration conf, String prefix) {
        if (conf == null) {
            throw new NullPointerException();
        }
        if (prefix == null) {
            throw new NullPointerException();
        }
        HashMap<String, String> knownNamespaces = new HashMap<String, String>();
        String nsConfPrefix = prefix + "namespace.";
        Iterator namespaces = conf.findPropertyKeys(nsConfPrefix);
        while (namespaces.hasNext()) {
            String key = (String)namespaces.next();
            String nsPrefix = key.substring(nsConfPrefix.length());
            String nsUri = conf.getConfigProperty(key);
            knownNamespaces.put(nsPrefix, nsUri);
        }
        this.defaultNamespace = (String)knownNamespaces.get(conf.getConfigProperty(prefix + "namespace"));
        String globalDefaultKey = prefix + "default";
        String globalValue = conf.getConfigProperty(globalDefaultKey);
        if (this.isValidHandler(globalValue)) {
            this.defaultDefinitions.put(null, globalValue);
        } else {
            this.defaultDefinitions.put(null, "");
        }
        String nsDefaultPrefix = prefix + "default.";
        Iterator defaults = conf.findPropertyKeys(nsDefaultPrefix);
        while (defaults.hasNext()) {
            String tagData;
            String key = (String)defaults.next();
            String nsPrefix = key.substring(nsDefaultPrefix.length());
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null || (tagData = conf.getConfigProperty(key)) == null) continue;
            if (this.isValidHandler(tagData)) {
                this.defaultDefinitions.put(nsUri, tagData);
                continue;
            }
            this.defaultDefinitions.put(nsUri, "");
        }
        String nsTagsPrefix = prefix + "tag.";
        Iterator tags = conf.findPropertyKeys(nsTagsPrefix);
        while (tags.hasNext()) {
            String key = (String)tags.next();
            String tagDef = key.substring(nsTagsPrefix.length());
            String tagData = conf.getConfigProperty(key);
            if (tagData == null || !this.isValidHandler(tagData)) continue;
            int delim = tagDef.indexOf(46);
            if (delim == -1) {
                this.tagData.put(new TagDefinitionKey(null, tagDef), tagData);
                continue;
            }
            String nsPrefix = tagDef.substring(0, delim);
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null) continue;
            String tagName = tagDef.substring(delim + 1);
            this.tagData.put(new TagDefinitionKey(nsUri, tagName), tagData);
        }
    }

    private boolean isValidHandler(String className) {
        if (className == null) {
            return false;
        }
        BundleMetaDataEntryWriteHandler o = (BundleMetaDataEntryWriteHandler)ObjectUtilities.loadAndInstantiate((String)className, this.getClass(), BundleMetaDataEntryWriteHandler.class);
        return o != null;
    }

    public BundleMetaDataEntryWriteHandler getHandler(String namespace, String tagname) {
        TagDefinitionKey key;
        String tagVal;
        if (namespace == null) {
            namespace = this.defaultNamespace;
        }
        if ((tagVal = this.tagData.get(key = new TagDefinitionKey(namespace, tagname))) != null) {
            return (BundleMetaDataEntryWriteHandler)ObjectUtilities.loadAndInstantiate((String)tagVal, this.getClass(), BundleMetaDataEntryWriteHandler.class);
        }
        String className = this.defaultDefinitions.get(namespace);
        if (className != null) {
            return (BundleMetaDataEntryWriteHandler)ObjectUtilities.loadAndInstantiate((String)className, this.getClass(), BundleMetaDataEntryWriteHandler.class);
        }
        String fallbackName = this.defaultDefinitions.get(null);
        BundleMetaDataEntryWriteHandler fallbackValue = (BundleMetaDataEntryWriteHandler)ObjectUtilities.loadAndInstantiate((String)fallbackName, this.getClass(), BundleMetaDataEntryWriteHandler.class);
        if (fallbackValue != null) {
            return fallbackValue;
        }
        return null;
    }

    private static class TagDefinitionKey {
        private String namespace;
        private String tagName;

        private TagDefinitionKey(String namespace, String tagName) {
            this.namespace = namespace;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagDefinitionKey that = (TagDefinitionKey)o;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
                return false;
            }
            return !(this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 29 * result + (this.tagName != null ? this.tagName.hashCode() : 0);
            return result;
        }
    }
}

