/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3KettleProperty {
    private static final Class<?> PKG = S3KettleProperty.class;
    private static final Logger logger = LoggerFactory.getLogger(S3KettleProperty.class);
    public static final String S3VFS_PART_SIZE = "s3.vfs.partSize";

    public String getPartSize() {
        return this.getProperty(S3VFS_PART_SIZE);
    }

    public String getProperty(String property) {
        String filename = Const.getKettlePropertiesFilename();
        String partSizeString = "";
        try {
            Properties properties = EnvUtil.readProperties((String)filename);
            partSizeString = properties.getProperty(property);
        }
        catch (KettleException ke) {
            logger.error(BaseMessages.getString(PKG, (String)"WARN.S3Commmon.PropertyNotFound", (String[])new String[]{property, filename}));
        }
        return partSizeString;
    }
}

