/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.pentaho.s3n.vfs.S3NFileSystem;

public class S3CommonFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String NAME = "name";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private static final String SESSION_TOKEN = "sessionToken";
    private static final String REGION = "region";
    private static final String CREDENTIALS_FILE = "credentialsFile";
    private static final String PROFILE_NAME = "profileName";
    private static final String ENDPOINT = "endpoint";
    private static final String SIGNATURE_VERSION = "signature_version";
    private static final String PATHSTYLE_ACCESS = "pathSyleAccess";
    private static final String DEFAULT_S3_CONFIG = "defaultS3Config";
    private static final String CONNECTION_TYPE = "connectionType";
    private FileSystemOptions fileSystemOptions;

    public S3CommonFileSystemConfigBuilder(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public void setName(String name) {
        this.setParam(this.getFileSystemOptions(), NAME, name);
    }

    public String getName() {
        return (String)this.getParam(this.getFileSystemOptions(), NAME);
    }

    public void setAccessKey(String accessKey) {
        this.setParam(this.getFileSystemOptions(), ACCESS_KEY, accessKey);
    }

    public String getAccessKey() {
        return (String)this.getParam(this.getFileSystemOptions(), ACCESS_KEY);
    }

    public void setSecretKey(String secretKey) {
        this.setParam(this.getFileSystemOptions(), SECRET_KEY, secretKey);
    }

    public String getSecretKey() {
        return (String)this.getParam(this.getFileSystemOptions(), SECRET_KEY);
    }

    public void setSessionToken(String sessionToken) {
        this.setParam(this.getFileSystemOptions(), SESSION_TOKEN, sessionToken);
    }

    public String getSessionToken() {
        return (String)this.getParam(this.getFileSystemOptions(), SESSION_TOKEN);
    }

    public void setRegion(String region) {
        this.setParam(this.getFileSystemOptions(), REGION, region);
    }

    public String getRegion() {
        return (String)this.getParam(this.getFileSystemOptions(), REGION);
    }

    public void setCredentialsFile(String credentialsFile) {
        this.setParam(this.getFileSystemOptions(), CREDENTIALS_FILE, credentialsFile);
    }

    public String getCredentialsFile() {
        return (String)this.getParam(this.getFileSystemOptions(), CREDENTIALS_FILE);
    }

    public String getProfileName() {
        return (String)this.getParam(this.getFileSystemOptions(), PROFILE_NAME);
    }

    public void setProfileName(String profileName) {
        this.setParam(this.getFileSystemOptions(), PROFILE_NAME, profileName);
    }

    public void setEndpoint(String endpoint) {
        this.setParam(this.getFileSystemOptions(), ENDPOINT, endpoint);
    }

    public String getEndpoint() {
        return (String)this.getParam(this.getFileSystemOptions(), ENDPOINT);
    }

    public void setSignatureVersion(String signatureVersion) {
        this.setParam(this.getFileSystemOptions(), SIGNATURE_VERSION, signatureVersion);
    }

    public String getSignatureVersion() {
        return (String)this.getParam(this.getFileSystemOptions(), SIGNATURE_VERSION);
    }

    public void setPathStyleAccess(String pathStyleAccess) {
        this.setParam(this.getFileSystemOptions(), PATHSTYLE_ACCESS, pathStyleAccess);
    }

    public String getPathStyleAccess() {
        return (String)this.getParam(this.getFileSystemOptions(), PATHSTYLE_ACCESS);
    }

    public void setDefaultS3Config(String defaultS3Config) {
        this.setParam(this.getFileSystemOptions(), PATHSTYLE_ACCESS, defaultS3Config);
    }

    public String getDefaultS3Config() {
        return (String)this.getParam(this.getFileSystemOptions(), DEFAULT_S3_CONFIG);
    }

    public void setConnectionType(String connectionType) {
        this.setParam(this.getFileSystemOptions(), CONNECTION_TYPE, connectionType);
    }

    public String getConnectionType() {
        return (String)this.getParam(this.getFileSystemOptions(), CONNECTION_TYPE);
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return S3NFileSystem.class;
    }
}

