/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3.provider;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileSystemOptions;
import org.pentaho.amazon.s3.S3Details;
import org.pentaho.amazon.s3.S3Util;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.vfs.BaseVFSConnectionProvider;
import org.pentaho.di.connections.vfs.VFSRoot;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.s3common.S3CommonFileSystemConfigBuilder;

public class S3Provider
extends BaseVFSConnectionProvider<S3Details> {
    private static final String ACCESS_KEY_SECRET_KEY = "0";
    private static final String CREDENTIALS_FILE = "1";
    public static final String NAME = "Amazon S3/Minio";
    private final Supplier<ConnectionManager> connectionManagerSupplier = ConnectionManager::getInstance;
    private final LogChannelInterface log = new LogChannel((Object)this);

    public Class<S3Details> getClassType() {
        return S3Details.class;
    }

    public FileSystemOptions getOpts(S3Details s3Details) {
        VariableSpace space = this.getSpace((ConnectionDetails)s3Details);
        S3CommonFileSystemConfigBuilder s3CommonFileSystemConfigBuilder = new S3CommonFileSystemConfigBuilder(new FileSystemOptions());
        s3CommonFileSystemConfigBuilder.setName(this.getVar(s3Details.getName(), space));
        s3CommonFileSystemConfigBuilder.setAccessKey(this.getVar(s3Details.getAccessKey(), space));
        s3CommonFileSystemConfigBuilder.setSecretKey(this.getVar(s3Details.getSecretKey(), space));
        s3CommonFileSystemConfigBuilder.setSessionToken(this.getVar(s3Details.getSessionToken(), space));
        s3CommonFileSystemConfigBuilder.setRegion(this.getVar(s3Details.getRegion(), space));
        s3CommonFileSystemConfigBuilder.setCredentialsFile(this.getVar(s3Details.getCredentialsFilePath(), space));
        s3CommonFileSystemConfigBuilder.setProfileName(this.getVar(s3Details.getProfileName(), space));
        s3CommonFileSystemConfigBuilder.setEndpoint(this.getVar(s3Details.getEndpoint(), space));
        s3CommonFileSystemConfigBuilder.setPathStyleAccess(this.getVar(s3Details.getPathStyleAccess(), space));
        s3CommonFileSystemConfigBuilder.setSignatureVersion(this.getVar(s3Details.getSignatureVersion(), space));
        s3CommonFileSystemConfigBuilder.setDefaultS3Config(this.getVar(s3Details.getDefaultS3Config(), space));
        s3CommonFileSystemConfigBuilder.setConnectionType(this.getVar(s3Details.getConnectionType(), space));
        return s3CommonFileSystemConfigBuilder.getFileSystemOptions();
    }

    public List<S3Details> getConnectionDetails() {
        return this.connectionManagerSupplier.get().getConnectionDetailsByScheme(this.getKey());
    }

    public List<VFSRoot> getLocations(S3Details s3Details) {
        VariableSpace space = this.getSpace((ConnectionDetails)s3Details);
        ArrayList<VFSRoot> buckets = new ArrayList<VFSRoot>();
        try {
            AmazonS3 s3 = this.getAmazonS3(s3Details, space);
            if (s3 != null) {
                for (Bucket bucket : s3.listBuckets()) {
                    buckets.add(new VFSRoot(bucket.getName(), bucket.getCreationDate()));
                }
            }
        }
        catch (Exception e) {
            this.log.logError(e.getMessage(), (Throwable)e);
            throw e;
        }
        return buckets;
    }

    public String getName() {
        return NAME;
    }

    public String getKey() {
        return "s3";
    }

    public String getProtocol(S3Details s3Details) {
        return "s3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test(S3Details s3Details) throws KettleException {
        VariableSpace space = this.getSpace((ConnectionDetails)s3Details);
        s3Details = this.prepare(s3Details);
        AmazonS3 amazonS3 = this.getAmazonS3(s3Details, space);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Objects.requireNonNull(amazonS3).getS3AccountOwner();
            List connections = this.connectionManagerSupplier.get().getConnectionDetailsByScheme("s3");
            if (S3Provider.getBooleanValueOfVariable((VariableSpace)space, (String)s3Details.getDefaultS3ConfigVariable(), (String)s3Details.getDefaultS3Config())) {
                for (ConnectionDetails details : connections) {
                    if (s3Details.getName().equalsIgnoreCase(details.getName())) continue;
                    S3Details removeDefault = (S3Details)details;
                    removeDefault.setAccessKey(Encr.decryptPasswordOptionallyEncrypted((String)this.getVar(removeDefault.getAccessKey(), space)));
                    removeDefault.setSecretKey(Encr.decryptPasswordOptionallyEncrypted((String)this.getVar(removeDefault.getSecretKey(), space)));
                    removeDefault.setSessionToken(Encr.decryptPasswordOptionallyEncrypted((String)this.getVar(removeDefault.getSessionToken(), space)));
                    removeDefault.setCredentialsFile(Encr.decryptPasswordOptionallyEncrypted((String)this.getVar(removeDefault.getCredentialsFile(), space)));
                    removeDefault.setDefaultS3Config("false");
                    removeDefault.setDefaultS3ConfigVariable(null);
                    this.connectionManagerSupplier.get().save((ConnectionDetails)removeDefault);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (AmazonS3Exception e) {
            this.log.logError(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.log.logError(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public S3Details prepare(S3Details s3Details) throws KettleException {
        String credentialsFilePath;
        VariableSpace space = this.getSpace((ConnectionDetails)s3Details);
        if (s3Details.getAuthType().equals(CREDENTIALS_FILE) && (credentialsFilePath = this.getVar(s3Details.getCredentialsFilePath(), space)) != null) {
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(credentialsFilePath, new String[0]));){
                String currentLine;
                StringBuilder builder = new StringBuilder();
                while ((currentLine = reader.readLine()) != null) {
                    builder.append(currentLine).append("\n");
                }
                s3Details.setCredentialsFile(builder.toString());
            }
            catch (IOException e) {
                throw new KettleException("Could not read file ", (Throwable)e);
            }
        }
        return s3Details;
    }

    private AmazonS3 getAmazonS3(S3Details s3Details, VariableSpace space) {
        Regions regions;
        boolean access;
        ProfileCredentialsProvider awsCredentialsProvider = null;
        String accessKey = this.getVar(s3Details.getAccessKey(), space);
        String secretKey = this.getVar(s3Details.getSecretKey(), space);
        String sessionToken = this.getVar(s3Details.getSessionToken(), space);
        String credentialsFilePath = this.getVar(s3Details.getCredentialsFilePath(), space);
        String profileName = this.getVar(s3Details.getProfileName(), space);
        String endpoint = this.getVar(s3Details.getEndpoint(), space);
        String pathStyleAccess = this.getBooleanStringOfVariable(s3Details.getPathStyleAccessVariable(), s3Details.getPathStyleAccess(), space);
        String signatureVersion = this.getVar(s3Details.getSignatureVersion(), space);
        boolean bl = access = pathStyleAccess == null || Boolean.parseBoolean(pathStyleAccess);
        if (s3Details.getAuthType().equals(ACCESS_KEY_SECRET_KEY)) {
            Object awsCredentials = S3Util.isEmpty(this.getVar(s3Details.getSessionToken(), space)) ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
            awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        }
        if (s3Details.getAuthType().equals(CREDENTIALS_FILE)) {
            ProfilesConfigFile profilesConfigFile = new ProfilesConfigFile(credentialsFilePath);
            awsCredentialsProvider = new ProfileCredentialsProvider(profilesConfigFile, profileName);
        }
        String region = this.getVar(s3Details.getRegion(), space);
        String endPoint = this.getVar(s3Details.getEndpoint(), space);
        Regions regions2 = regions = !S3Util.isEmpty(region) ? Regions.fromName((String)region) : Regions.DEFAULT_REGION;
        if (awsCredentialsProvider != null && S3Util.isEmpty(endPoint)) {
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).enableForceGlobalBucketAccess()).withRegion(regions)).build();
        }
        if (awsCredentialsProvider != null && !S3Util.isEmpty(endPoint)) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setSignerOverride(S3Util.isEmpty(signatureVersion) ? "aws.endpoint" : signatureVersion);
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, regions.getName()))).withPathStyleAccessEnabled(Boolean.valueOf(access))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).build();
        }
        return null;
    }

    private String getBooleanStringOfVariable(String variableName, String defaultValue, VariableSpace space) {
        return String.valueOf(S3Provider.getBooleanValueOfVariable((VariableSpace)space, (String)variableName, (String)defaultValue));
    }
}

