/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import java.util.List;
import mondrian.olap.Util;
import org.pentaho.amazon.s3.S3FileOutput;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="S3FileOutputPlugin", image="S3O.svg", name="S3FileOutput.Name", description="S3FileOutput.Description", documentationUrl="Products/S3_File_Output", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Output", i18nPackageName="org.pentaho.amazon.s3")
@InjectionSupported(localizationPrefix="S3FileOutput.Injection.", groups={"OUTPUT_FIELDS"})
public class S3FileOutputMeta
extends TextFileOutputMeta {
    private static final String ACCESS_KEY_TAG = "access_key";
    private static final String SECRET_KEY_TAG = "secret_key";
    private static final String FILE_TAG = "file";
    private static final String NAME_TAG = "name";
    private String accessKey = null;
    private String secretKey = null;

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setDefault() {
        super.setDefault();
        this.setFileName("s3n://s3n");
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(1000);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)ACCESS_KEY_TAG, (String)Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey)));
        retval.append("      ").append(XMLHandler.addTagValue((String)SECRET_KEY_TAG, (String)Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey)));
        return retval.toString();
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            super.saveRep(rep, metaStore, id_transformation, id_step);
            rep.saveStepAttribute(id_transformation, id_step, ACCESS_KEY_TAG, Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey));
            rep.saveStepAttribute(id_transformation, id_step, SECRET_KEY_TAG, Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey));
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            super.readRep(rep, metaStore, id_step, databases);
            this.setAccessKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, ACCESS_KEY_TAG)));
            this.setSecretKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, SECRET_KEY_TAG)));
            String filename = rep.getStepAttributeString(id_step, "file_name");
            this.processFilename(filename);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void readData(Node stepnode) throws KettleXMLException {
        try {
            super.readData(stepnode);
            this.accessKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)ACCESS_KEY_TAG));
            this.secretKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)SECRET_KEY_TAG));
            String filename = XMLHandler.getTagValue((Node)stepnode, (String)FILE_TAG, (String)NAME_TAG);
            this.processFilename(filename);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new S3FileOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    protected void processFilename(String filename) throws Exception {
        if (Util.isEmpty((String)filename)) {
            filename = "s3n://s3n/";
        }
        this.setFileName(filename);
    }

    protected String decodeAccessKey(String key) {
        if (Const.isEmpty((String)key)) {
            return key;
        }
        return key.replaceAll("%2B", "\\+").replaceAll("%2F", "/");
    }
}

