/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import com.google.common.annotations.VisibleForTesting;
import org.pentaho.amazon.s3.S3FileOutputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;

public class S3FileOutput
extends TextFileOutput {
    public S3FileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.init(smi);
        return super.init(smi, sdi);
    }

    public void markStop() {
        super.markStop();
        String accessKeySystemProperty = System.getProperty("aws.accessKeyId");
        String secretKeySystemProperty = System.getProperty("aws.secretKey");
        if (!StringUtil.isEmpty((String)accessKeySystemProperty)) {
            System.setProperty("aws.accessKeyId", "");
        }
        if (!StringUtil.isEmpty((String)secretKeySystemProperty)) {
            System.setProperty("aws.secretKey", "");
        }
    }

    @VisibleForTesting
    void init(StepMetaInterface smi) {
        if (!ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_USE_AWS_DEFAULT_CREDENTIALS"), (String)"N")).booleanValue()) {
            S3FileOutputMeta s3Meta = (S3FileOutputMeta)smi;
            String accessKeySystemProperty = System.getProperty("aws.accessKeyId");
            String secretKeySystemProperty = System.getProperty("aws.secretKey");
            if (!StringUtil.isEmpty((String)s3Meta.getAccessKey()) && StringUtil.isEmpty((String)accessKeySystemProperty)) {
                System.setProperty("aws.accessKeyId", Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(s3Meta.getAccessKey())));
            }
            if (!StringUtil.isEmpty((String)s3Meta.getSecretKey()) && StringUtil.isEmpty((String)secretKeySystemProperty)) {
                System.setProperty("aws.secretKey", Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(s3Meta.getSecretKey())));
            }
        }
    }
}

