/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.pentaho.amazon.s3.provider.S3Provider;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.ConnectionProvider;
import org.pentaho.di.connections.LookupFilter;
import org.pentaho.di.connections.vfs.VFSLookupFilter;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.s3n.vfs.S3NFileProvider;

@KettleLifecyclePlugin(id="AmazonS3NFileSystemBootstrap", name="Amazon S3N FileSystem Bootstrap")
public class AmazonS3NFileSystemBootstrap
implements KettleLifecycleListener {
    private static Class<?> amazonS3NFileSystemBootstrapClass = AmazonS3NFileSystemBootstrap.class;
    private LogChannelInterface log = new LogChannel((Object)AmazonS3NFileSystemBootstrap.class.getName());
    private Supplier<ConnectionManager> connectionManager = ConnectionManager::getInstance;

    public static String getS3NFileSystemDisplayText() {
        return BaseMessages.getString(amazonS3NFileSystemBootstrapClass, (String)"S3NVfsFileChooserDialog.FileSystemChoice.S3.Label", (String[])new String[0]);
    }

    public void onEnvironmentInit() throws LifecycleException {
        try {
            FileSystemManager fsm = KettleVFS.getInstance().getFileSystemManager();
            if (fsm instanceof DefaultFileSystemManager && !Arrays.asList(fsm.getSchemes()).contains("s3n")) {
                ((DefaultFileSystemManager)fsm).addProvider("s3n", (FileProvider)new S3NFileProvider());
            }
            if (this.connectionManager.get() != null) {
                this.connectionManager.get().addConnectionProvider("s3", (ConnectionProvider)new S3Provider());
                VFSLookupFilter vfsLookupFilter = new VFSLookupFilter();
                this.connectionManager.get().addLookupFilter((LookupFilter)vfsLookupFilter);
            }
        }
        catch (FileSystemException e) {
            this.log.logError(BaseMessages.getString(amazonS3NFileSystemBootstrapClass, (String)"AmazonSpoonPlugin.StartupError.FailedToLoadS3Driver", (String[])new String[0]));
        }
    }

    public void onEnvironmentShutdown() {
    }
}

