/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.extension;

import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;
import org.pentaho.di.ui.repo.dialog.RepositoryConnectionDialog;
import org.pentaho.di.ui.spoon.Spoon;

@ExtensionPoint(id="RepositorySpoonStartExtensionPoint", extensionPointId="SpoonStart", description="Do or display login for default repository")
public class RepositorySpoonStartExtensionPoint
implements ExtensionPointInterface {
    private static Class<?> PKG = RepositorySpoonStartExtensionPoint.class;
    private RepositoryConnectController repositoryConnectController = RepositoryConnectController.getInstance();

    public static CommandLineOption getCommandLineOption(CommandLineOption[] options, String opt) {
        for (CommandLineOption option : options) {
            if (!option.getOption().equals(opt)) continue;
            return option;
        }
        return null;
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        RepositoryMeta repositoryMeta;
        if (!(object instanceof CommandLineOption[])) {
            return;
        }
        CommandLineOption[] options = (CommandLineOption[])object;
        StringBuilder optionRepname = RepositorySpoonStartExtensionPoint.getCommandLineOption(options, "rep").getArgument();
        StringBuilder optionFilename = RepositorySpoonStartExtensionPoint.getCommandLineOption(options, "file").getArgument();
        StringBuilder optionUsername = RepositorySpoonStartExtensionPoint.getCommandLineOption(options, "user").getArgument();
        StringBuilder optionPassword = RepositorySpoonStartExtensionPoint.getCommandLineOption(options, "pass").getArgument();
        if (!Utils.isEmpty((CharSequence)optionRepname) && Utils.isEmpty((CharSequence)optionFilename)) {
            RepositoryMeta repositoryMeta2 = this.repositoryConnectController.getRepositoryMetaByName(optionRepname.toString());
            if (repositoryMeta2 != null && !Utils.isEmpty((CharSequence)optionUsername) && !Utils.isEmpty((CharSequence)optionPassword)) {
                this.repositoryConnectController.connectToRepository(repositoryMeta2, optionUsername.toString(), optionPassword.toString());
            } else if (repositoryMeta2 != null) {
                this.repositoryConnectController.connectToRepository(repositoryMeta2, null, null);
            }
            if (!this.repositoryConnectController.isConnected()) {
                String msg = BaseMessages.getString(PKG, (String)"Repository.NoConnected.Message", (String[])new String[0]);
                log.logError(msg);
                MessageBox mb = new MessageBox(this.getSpoon().getShell(), 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"Repository.NoConnected.Message", (String[])new String[]{optionRepname.toString()}));
                mb.setText(BaseMessages.getString(PKG, (String)"Repository.NoConnected.Message.Title", (String[])new String[0]));
                mb.open();
            }
        } else if (Utils.isEmpty((CharSequence)optionFilename) && (repositoryMeta = this.repositoryConnectController.getDefaultRepositoryMeta()) != null) {
            if (repositoryMeta.getId().equals("KettleFileRepository")) {
                this.repositoryConnectController.connectToRepository(repositoryMeta);
            } else {
                new RepositoryConnectionDialog(this.getSpoon().getShell()).createDialog(repositoryMeta.getName());
            }
        }
    }

    private Spoon getSpoon() {
        return Spoon.getInstance();
    }
}

