/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;
import org.pentaho.di.ui.repo.dialog.BaseRepoFormComposite;
import org.pentaho.di.ui.repo.dialog.KettleDatabaseRepoFormComposite;
import org.pentaho.di.ui.repo.dialog.KettleFileRepoFormComposite;
import org.pentaho.di.ui.repo.dialog.PentahoEnterpriseRepoFormComposite;
import org.pentaho.di.ui.repo.dialog.RepositoryConnectionDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class RepositoryManagerDialog
extends Dialog {
    public static final int MARGIN = 15;
    protected Shell dialog;
    protected Display display;
    protected Label lblHeader;
    protected Label lblNote;
    protected Button btnAdd;
    protected PropsUI props;
    protected Runnable refreshList;
    protected Runnable setToList;
    protected BiConsumer<String, JSONObject> setToEditor;
    protected Runnable saveAction;
    protected Map<String, RepositoryInfo> repositoryInfos;
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final Class<?> PKG = RepositoryManagerDialog.class;
    private LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create(RepositoryManagerDialog.class);
    private static final String HELP_URL = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"repositories.repohelpurl.label", (String[])new String[0]));

    public RepositoryManagerDialog(Shell parent) {
        super(parent);
        this.props = PropsUI.getInstance();
    }

    public void open(int width, int height, String connectedRepositoryName, RepositoriesMeta repositoriesMeta) {
        this.display = this.getParent().getDisplay();
        this.dialog = new Shell(this.getParent(), 67696);
        this.dialog.setSize(width, height);
        this.dialog.setImage(LOGO);
        this.props.setLook((Control)this.dialog);
        this.dialog.setText(BaseMessages.getString(PKG, (String)"repositories.repomanager.label", (String[])new String[0]));
        FormLayout fl = new FormLayout();
        fl.marginHeight = 15;
        fl.marginWidth = 15;
        this.dialog.setLayout((Layout)fl);
        this.lblHeader = new Label((Composite)this.dialog, 0);
        Font headerFont = new Font((Device)this.display, (FontData[])Arrays.stream(this.lblHeader.getFont().getFontData()).map(fd -> {
            fd.setHeight(24);
            fd.setStyle(1);
            return fd;
        }).toArray(FontData[]::new));
        this.lblHeader.setFont(headerFont);
        this.lblHeader.addDisposeListener(d -> headerFont.dispose());
        this.lblHeader.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top(0, 0).result());
        this.props.setLook((Control)this.lblHeader);
        this.lblNote = new Label((Composite)this.dialog, 0);
        this.lblNote.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)this.lblHeader, 5).result());
        this.props.setLook((Control)this.lblNote);
        Label lblSep = new Label((Composite)this.dialog, 258);
        lblSep.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)this.lblNote, 15).height(2).result());
        this.props.setLook((Control)lblSep);
        Button btnHelp = new Button((Composite)this.dialog, 8);
        btnHelp.setText(BaseMessages.getString(PKG, (String)"repositories.help.label", (String[])new String[0]));
        btnHelp.setLayoutData((Object)new FormDataBuilder().left(0, 0).bottom(100, 0).width(80).height(35).result());
        this.props.setLook((Control)btnHelp);
        btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)HELP_URL);
            }
        });
        Composite buttonsComposite = new Composite((Composite)this.dialog, 0);
        buttonsComposite.setLayoutData((Object)new FormDataBuilder().bottom(100, 0).right(100, 0).left((Control)btnHelp, 15).height(35).result());
        StackLayout buttonStack = new StackLayout();
        buttonStack.marginHeight = 0;
        buttonStack.marginWidth = 0;
        buttonsComposite.setLayout((Layout)buttonStack);
        this.props.setLook((Control)buttonsComposite);
        Composite closeComposite = new Composite(buttonsComposite, 0);
        FormLayout closeLayout = new FormLayout();
        closeLayout.marginWidth = 0;
        closeLayout.marginHeight = 0;
        closeComposite.setLayout((Layout)closeLayout);
        this.props.setLook((Control)closeComposite);
        Button btnClose = new Button(closeComposite, 8);
        btnClose.setLayoutData((Object)new FormDataBuilder().bottom(100, 0).right(100, 0).top(0, 0).width(80).result());
        this.props.setLook((Control)btnClose);
        btnClose.setText(BaseMessages.getString(PKG, (String)"repositories.close.label", (String[])new String[0]));
        this.dialog.setDefaultButton(btnClose);
        btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryManagerDialog.this.dialog.dispose();
            }
        });
        Composite editorButtonsComposite = new Composite(buttonsComposite, 0);
        FormLayout flEditorButtons = new FormLayout();
        flEditorButtons.marginHeight = 0;
        flEditorButtons.marginWidth = 0;
        editorButtonsComposite.setLayout((Layout)flEditorButtons);
        this.props.setLook((Control)editorButtonsComposite);
        Button btnCancel = new Button(editorButtonsComposite, 8);
        btnCancel.setText(BaseMessages.getString(PKG, (String)"repositories.cancel.label", (String[])new String[0]));
        btnCancel.setLayoutData((Object)new FormDataBuilder().right(100, 0).top(0, 0).bottom(100, 0).width(80).result());
        this.props.setLook((Control)btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryManagerDialog.this.setToList.run();
            }
        });
        Button btnSave = new Button(editorButtonsComposite, 8);
        btnSave.setText(BaseMessages.getString(PKG, (String)"repositories.save.label", (String[])new String[0]));
        this.props.setLook((Control)btnSave);
        btnSave.setLayoutData((Object)new FormDataBuilder().right((Control)btnCancel, -5).top(0, 0).bottom(100, 0).width(80).result());
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryManagerDialog.this.saveAction.run();
            }
        });
        StackLayout sl = new StackLayout();
        Composite stackComposite = new Composite((Composite)this.dialog, 0);
        stackComposite.setLayout((Layout)sl);
        this.props.setLook((Control)stackComposite);
        stackComposite.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)lblSep, 4).bottom((Control)buttonsComposite, -5).result());
        stackComposite.setBackground(this.display.getSystemColor(1));
        Composite repoListComp = this.buildRepoListComposite(stackComposite, connectedRepositoryName, repositoriesMeta);
        this.props.setLook((Control)repoListComp);
        this.repositoryInfos = new LinkedHashMap<String, RepositoryInfo>();
        List repoPlugins = PluginRegistry.getInstance().getPlugins(RepositoryPluginType.class);
        this.repositoryInfos = repoPlugins.stream().sorted(Comparator.comparing(pi -> pi.getDescription().length()).reversed()).flatMap(pi -> {
            switch (pi.getIds()[0]) {
                case "PentahoEnterpriseRepository": {
                    return Stream.of(new RepositoryInfo((PluginInterface)pi, new PentahoEnterpriseRepoFormComposite(stackComposite, 0)));
                }
                case "KettleFileRepository": {
                    return Stream.of(new RepositoryInfo((PluginInterface)pi, new KettleFileRepoFormComposite(stackComposite, 0)));
                }
                case "KettleDatabaseRepository": {
                    return Stream.of(new RepositoryInfo((PluginInterface)pi, new KettleDatabaseRepoFormComposite(stackComposite, 0){}));
                }
            }
            return Stream.empty();
        }).collect(Collectors.toMap(ri -> ri.getId(), Function.identity(), (r, i) -> r, LinkedHashMap::new));
        SelectionAdapter menuSelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData() != null) {
                    RepositoryManagerDialog.this.setToEditor.accept((String)e.widget.getData(), null);
                }
            }
        };
        final Menu addPopUp = new Menu((Control)this.btnAdd);
        for (RepositoryInfo ri2 : this.repositoryInfos.values()) {
            MenuItem mi = new MenuItem(addPopUp, 64);
            mi.setText(ri2.getName());
            mi.setToolTipText(ri2.getDescription());
            mi.setData((Object)ri2.getId());
            mi.addSelectionListener((SelectionListener)menuSelListener);
        }
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = RepositoryManagerDialog.this.btnAdd.getBounds();
                Point p = RepositoryManagerDialog.this.btnAdd.getParent().toDisplay(r.x, r.y + r.height);
                addPopUp.setLocation(p);
                addPopUp.setVisible(true);
            }
        });
        this.setToList = () -> {
            this.lblHeader.setText(BaseMessages.getString(PKG, (String)"repositories.repos.label", (String[])new String[0]));
            this.lblNote.setText("Manage Pentaho repositories");
            this.refreshList.run();
            buttonStack.topControl = closeComposite;
            buttonsComposite.requestLayout();
            this.dialog.setDefaultButton(btnClose);
            sl.topControl = repoListComp;
            stackComposite.requestLayout();
        };
        this.setToEditor = (type, data) -> {
            RepositoryInfo ri = this.repositoryInfos.get(type);
            if (ri != null) {
                BaseRepoFormComposite repoComp = ri.getComposite();
                if (data != null) {
                    this.saveAction = () -> this.onUpdateRepository((String)type, repoComp.toMap());
                    repoComp.populate((JSONObject)data);
                } else {
                    this.saveAction = () -> this.onCreateRepository((String)type, repoComp.toMap());
                    repoComp.populate(new JSONObject());
                }
                String headerText = ri.getName();
                int posOfRec = ri.getName().indexOf("(");
                if (posOfRec > -1) {
                    headerText = headerText.substring(0, posOfRec);
                }
                this.lblHeader.setText(headerText);
                this.lblNote.setText(ri.getDescription());
                buttonStack.topControl = editorButtonsComposite;
                buttonsComposite.requestLayout();
                this.dialog.setDefaultButton(btnSave);
                repoComp.updateSaveButton(btnSave);
                sl.topControl = repoComp;
                stackComposite.requestLayout();
            }
        };
        this.setToList.run();
        int widthManager = this.display.getClientArea().width;
        int heightManager = this.display.getClientArea().height;
        this.dialog.setLocation((widthManager - this.dialog.getSize().x) / 2 + this.display.getClientArea().x, (heightManager - this.dialog.getSize().y) / 2 + this.display.getClientArea().y);
        this.dialog.open();
        this.refreshList.run();
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private Composite buildRepoListComposite(Composite parent, String connectedRepositoryName, final RepositoriesMeta repositoriesMeta) {
        Composite comp = new Composite(parent, 0);
        FormLayout fl = new FormLayout();
        fl.marginWidth = 15;
        fl.marginHeight = 15;
        comp.setLayout((Layout)fl);
        Composite btnComp = new Composite(comp, 0);
        btnComp.setLayout((Layout)new FormLayout());
        btnComp.setLayoutData((Object)new FormDataBuilder().right(100, 0).top(0, 0).bottom(100, 0).result());
        this.props.setLook((Control)btnComp);
        this.btnAdd = new Button(btnComp, 8);
        this.btnAdd.setText(BaseMessages.getString(PKG, (String)"repositories.add.label", (String[])new String[0]));
        this.btnAdd.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).result());
        this.props.setLook((Control)this.btnAdd);
        Button btnEdit = new Button(btnComp, 8);
        btnEdit.setText(BaseMessages.getString(PKG, (String)"repositories.edit.label", (String[])new String[0]));
        btnEdit.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)this.btnAdd, 15).result());
        this.props.setLook((Control)btnEdit);
        Button btnDelete = new Button(btnComp, 8);
        btnDelete.setText(BaseMessages.getString(PKG, (String)"repositories.delete.label", (String[])new String[0]));
        btnDelete.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)btnEdit, 15).result());
        this.props.setLook((Control)btnDelete);
        Button btnConnect = new Button(btnComp, 8);
        btnConnect.setText(BaseMessages.getString(PKG, (String)"repositories.connect.label", (String[])new String[0]));
        btnConnect.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)btnDelete, 15).result());
        this.props.setLook((Control)btnConnect);
        Label emptyLabel = new Label(btnComp, 0);
        emptyLabel.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)btnDelete, 0).width(80).result());
        this.props.setLook((Control)emptyLabel);
        final TableViewer repoList = new TableViewer(comp, 68096);
        repoList.getTable().setLayoutData((Object)new FormDataBuilder().left(0, 0).right((Control)btnComp, -15).top(0, 0).bottom(100, 0).result());
        repoList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.props.setLook(repoList.getControl());
        TableViewerColumn repoColumn = new TableViewerColumn(repoList, 0);
        repoColumn.getColumn().setWidth(370);
        final Font repoNameFont = new Font((Device)this.display, (FontData[])Arrays.stream(repoList.getTable().getFont().getFontData()).map(fd -> {
            fd.setHeight(16);
            return fd;
        }).toArray(FontData[]::new));
        repoList.getTable().addDisposeListener(d -> repoNameFont.dispose());
        GC gc = new GC((Drawable)repoColumn.getColumn().getParent().getDisplay());
        gc.setFont(repoNameFont);
        final int repoCellHeight = gc.textExtent((String)"REPOSITORY").y * 2;
        gc.dispose();
        repoColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                int indexOf;
                JSONObject o = (JSONObject)cell.getElement();
                String nameStr = (String)o.get((Object)"displayName");
                StyledString.Styler style = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = repoNameFont;
                        textStyle.foreground = RepositoryManagerDialog.this.display.getSystemColor(9);
                    }
                };
                StyledString name = new StyledString(nameStr + "\n", style);
                String description = (String)o.get((Object)"description");
                if (!Utils.isEmpty((CharSequence)description) && (indexOf = description.indexOf(10)) >= 0) {
                    description = description.substring(0, indexOf);
                }
                name.append(description, StyledString.COUNTER_STYLER);
                cell.setText(name.toString());
                cell.setStyleRanges(name.getStyleRanges());
                super.update(cell);
            }

            protected void measure(Event event, Object element) {
                super.measure(event, element);
                event.height = repoCellHeight;
            }
        });
        SwtUniversalImage swtImgCheck = SwtSvgImageUtil.getUniversalImage((Display)this.dialog.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"SUC.svg");
        final Image imgCheck = swtImgCheck.getAsBitmapForSize((Device)this.dialog.getDisplay(), 30, 30);
        repoList.getTable().addDisposeListener(d -> imgCheck.dispose());
        TableViewerColumn defaultColumn = new TableViewerColumn(repoList, 0);
        defaultColumn.getColumn().setWidth(30);
        defaultColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                JSONObject o = (JSONObject)element;
                if (Boolean.TRUE.equals(o.getOrDefault((Object)"isDefault", (Object)false))) {
                    return imgCheck;
                }
                return super.getImage(element);
            }
        });
        repoList.getTable().addListener(11, e -> {
            Rectangle r = repoList.getTable().getClientArea();
            repoColumn.getColumn().setWidth(Math.max(370, r.width - defaultColumn.getColumn().getWidth()));
        });
        btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = repoList.getStructuredSelection();
                if (!sel.isEmpty()) {
                    JSONObject item = (JSONObject)sel.getFirstElement();
                    String repoName = item.get((Object)"displayName").toString();
                    RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repoName);
                    if (item.get((Object)"id") != null && item.get((Object)"id").toString().equals(BaseMessages.getString((Class)PKG, (String)"repositories.kettleFileRepository.name", (String[])new String[0]))) {
                        if (repositoryMeta == null) {
                            repositoryMeta = new KettleFileRepositoryMeta(item.get((Object)"id").toString(), item.get((Object)"displayName").toString(), item.get((Object)"description").toString(), item.get((Object)"location").toString());
                        }
                        try {
                            RepositoryConnectController.getInstance().connectToRepository(repositoryMeta);
                            RepositoryManagerDialog.this.dialog.dispose();
                        }
                        catch (KettleException ke) {
                            RepositoryManagerDialog.this.log.logError(BaseMessages.getString((Class)PKG, (String)"repositories.kettleFileRepositoryConnect.exception", (String[])new String[0]), (Throwable)ke);
                        }
                    } else {
                        new RepositoryConnectionDialog(RepositoryManagerDialog.this.dialog.getShell()).createDialog(repoName);
                    }
                }
            }
        });
        btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = repoList.getStructuredSelection();
                if (!sel.isEmpty()) {
                    JSONObject item = (JSONObject)sel.getFirstElement();
                    String id = (String)item.getOrDefault((Object)"id", (Object)"");
                    RepositoryManagerDialog.this.setToEditor.accept(id, item);
                }
            }
        });
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSONObject item;
                String name;
                IStructuredSelection sel = repoList.getStructuredSelection();
                if (!sel.isEmpty() && !Utils.isEmpty((CharSequence)(name = (String)(item = (JSONObject)sel.getFirstElement()).getOrDefault((Object)"displayName", (Object)"")))) {
                    String deleteMessage = String.format("Are you sure you wish to remove the '%s' repository?", name);
                    MessageBox delBox = new MessageBox(RepositoryManagerDialog.this.dialog, 200);
                    delBox.setText(BaseMessages.getString((Class)PKG, (String)"repositories.delrepo.label", (String[])new String[0]));
                    delBox.setMessage(deleteMessage);
                    if (64 == delBox.open()) {
                        RepositoryManagerDialog.this.onDeleteRepository(name);
                        RepositoryManagerDialog.this.refreshList.run();
                    }
                }
            }
        });
        ISelectionChangedListener scl = sce -> {
            boolean enabled = true;
            boolean disabled = false;
            if (repoList.getStructuredSelection().isEmpty()) {
                enabled = false;
            } else {
                String id = (String)((JSONObject)repoList.getStructuredSelection().getFirstElement()).get((Object)"id");
                if (!this.repositoryInfos.containsKey(id)) {
                    enabled = false;
                }
            }
            btnEdit.setEnabled(enabled);
            btnDelete.setEnabled(enabled);
            btnConnect.setEnabled(enabled);
            if (connectedRepositoryName != null) {
                btnConnect.setEnabled(disabled);
            }
        };
        scl.selectionChanged(null);
        repoList.addPostSelectionChangedListener(scl);
        this.refreshList = () -> {
            List<Object> repos = new ArrayList();
            repos = RepositoryConnectController.getInstance().getRepositories();
            repoList.setInput(repos);
        };
        return comp;
    }

    private void onCreateRepository(String id, Map<String, Object> results) {
        JSONObject j = new JSONObject();
        j.putAll(results);
        try {
            RepositoryConnectController.getInstance().createRepository(id, results);
            this.log.logBasic("Repository: " + results.get("displayName") + " creation successfully");
        }
        catch (Exception e) {
            this.log.logError("Error creating repository", (Throwable)e);
        }
        this.setToList.run();
    }

    private void onUpdateRepository(String id, Map<String, Object> results) {
        JSONObject j = new JSONObject();
        j.putAll(results);
        try {
            RepositoryConnectController.getInstance().updateRepository(id, results);
            this.log.logBasic("Repository update successful");
        }
        catch (Exception e) {
            this.log.logError("Error updating repository", (Throwable)e);
        }
        this.setToList.run();
    }

    private void onDeleteRepository(String repoName) {
        try {
            RepositoryConnectController.getInstance().deleteRepository(repoName);
            this.log.logBasic("Repository delete successful");
        }
        catch (Exception e) {
            this.log.logError("Error deleting repository ", (Throwable)e);
        }
    }

    protected static class RepositoryInfo {
        private final String id;
        private final String name;
        private final String description;
        private final BaseRepoFormComposite composite;

        public RepositoryInfo(PluginInterface plugin, BaseRepoFormComposite composite) {
            this.id = plugin.getIds()[0];
            this.name = plugin.getName();
            this.description = plugin.getDescription();
            this.composite = composite;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public BaseRepoFormComposite getComposite() {
            return this.composite;
        }
    }
}

