/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.dialog;

import java.util.Arrays;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;

public class RepositoryConnectionDialog
extends Dialog {
    private LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create(RepositoryConnectionDialog.class);
    private static final Class<?> PKG = RepositoryConnectionDialog.class;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private Label lblFlag;
    private Button loginBtn;
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final String LOGIN_TITLE = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Login.Title", (String[])new String[0]);
    private static final String HELP_URL = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"repositories.repohelpurl.label", (String[])new String[0]));
    String flagMessageBlank = "                                                    ";

    public RepositoryConnectionDialog(Shell shell) {
        super(shell, 0);
    }

    public boolean createDialog(final String strRepoName) {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2144);
        this.props.setLook((Control)this.shell);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(LOGIN_TITLE);
        this.shell.setImage(LOGO);
        try {
            Label lblConnectTo = new Label((Composite)this.shell, 0);
            this.props.setLook((Control)lblConnectTo);
            lblConnectTo.setLayoutData((Object)new FormDataBuilder().top(10, 0).left(5, 0).result());
            Font fontConnectTo = new Font((Device)display, (FontData[])Arrays.stream(lblConnectTo.getFont().getFontData()).map(fd -> {
                fd.setHeight(16);
                fd.setStyle(1);
                return fd;
            }).toArray(FontData[]::new));
            lblConnectTo.setFont(fontConnectTo);
            lblConnectTo.setText(BaseMessages.getString(PKG, (String)"repositories.connectto.label", (String[])new String[0]));
            Label lblRepoName = new Label((Composite)this.shell, 0);
            this.props.setLook((Control)lblRepoName);
            lblRepoName.setLayoutData((Object)new FormDataBuilder().top((Control)lblConnectTo).left(5, 0).result());
            lblRepoName.setText(strRepoName);
            Label lblUserName = new Label((Composite)this.shell, 0);
            this.props.setLook((Control)lblUserName);
            lblUserName.setLayoutData((Object)new FormDataBuilder().top((Control)lblRepoName, 10).left(5, 0).result());
            lblUserName.setText(BaseMessages.getString(PKG, (String)"repositories.username.label", (String[])new String[0]));
            final Text txtUserName = new Text((Composite)this.shell, 2048);
            this.props.setLook((Control)txtUserName);
            txtUserName.setLayoutData((Object)new FormDataBuilder().top((Control)lblUserName).left(5, 0).right(95, 0).result());
            Label lblPassword = new Label((Composite)this.shell, 0);
            this.props.setLook((Control)lblPassword);
            lblPassword.setLayoutData((Object)new FormDataBuilder().top((Control)txtUserName, 10).left(5, 0).result());
            lblPassword.setText(BaseMessages.getString(PKG, (String)"repositories.password.label", (String[])new String[0]));
            final Text txtPasswd = new Text((Composite)this.shell, 0x400800);
            this.props.setLook((Control)txtPasswd);
            txtPasswd.setLayoutData((Object)new FormDataBuilder().top((Control)lblPassword).left(5, 0).right(95, 0).result());
            this.lblFlag = new Label((Composite)this.shell, 0);
            this.props.setLook((Control)this.lblFlag);
            this.lblFlag.setLayoutData((Object)new FormDataBuilder().top((Control)txtPasswd, 10).left(5, 0).result());
            this.lblFlag.setText(this.flagMessageBlank);
            this.loginBtn = new Button((Composite)this.shell, 0);
            this.props.setLook((Control)this.loginBtn);
            this.loginBtn.setLayoutData((Object)new FormDataBuilder().top((Control)this.lblFlag).left(78, 0).width(80).result());
            this.loginBtn.setText(BaseMessages.getString(PKG, (String)"repositories.login.label", (String[])new String[0]));
            Button btnHelp = new Button((Composite)this.shell, 0);
            this.props.setLook((Control)btnHelp);
            btnHelp.setLayoutData((Object)new FormDataBuilder().top((Control)this.lblFlag).left(5, 0).width(80).result());
            btnHelp.setText(BaseMessages.getString(PKG, (String)"repositories.help.label", (String[])new String[0]));
            Button cnclBtn = new Button((Composite)this.shell, 0);
            this.props.setLook((Control)cnclBtn);
            cnclBtn.setLayoutData((Object)new FormDataBuilder().top((Control)this.lblFlag).left(57, 0).width(80).result());
            cnclBtn.setText(BaseMessages.getString(PKG, (String)"repositories.cancel.label", (String[])new String[0]));
            cnclBtn.addListener(13, event -> this.shell.dispose());
            btnHelp.addListener(13, event -> Program.launch((String)HELP_URL));
            txtPasswd.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13) {
                        RepositoryConnectionDialog.this.loginExecution(strRepoName, txtUserName, txtPasswd);
                    }
                }
            });
            this.loginBtn.addListener(13, event -> this.loginExecution(strRepoName, txtUserName, txtPasswd));
            this.shell.pack();
            this.shell.setMinimumSize(500, 400);
            int width = display.getClientArea().width;
            int height = display.getClientArea().height;
            this.shell.setLocation((width - this.shell.getSize().x) / 2 + display.getClientArea().x, (height - this.shell.getSize().y) / 2 + display.getClientArea().y);
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return true;
        }
        catch (Exception e) {
            this.log.logError("Error occurred creating dialog", (Throwable)e);
            return false;
        }
    }

    private void loginExecution(String strRepoName, Text txtUserName, Text txtPasswd) {
        String strUserName = txtUserName.getText();
        String strPasswd = txtPasswd.getText();
        if (Utils.isEmpty((CharSequence)strUserName)) {
            this.messageBoxService(" User name cannot be blank!");
        } else if (Utils.isEmpty((CharSequence)strPasswd)) {
            this.messageBoxService(" Password cannot be blank!");
        } else {
            this.lblFlag.setForeground(new Color((Device)this.lblFlag.getDisplay(), 0, 153, 76));
            this.lblFlag.setText("Please wait while connecting . . .");
            this.loginBtn.setEnabled(false);
            BusyIndicator.showWhile((Display)this.loginBtn.getDisplay(), () -> this.callLoginEndPoint(strRepoName, strUserName, strPasswd));
        }
    }

    public boolean callLoginEndPoint(String strRepoName, String strUserName, String strPasswd) {
        try {
            if (RepositoryConnectController.getInstance().isRelogin()) {
                RepositoryConnectController.getInstance().reconnectToRepository(strRepoName, strUserName, strPasswd);
            } else {
                RepositoryConnectController.getInstance().connectToRepository(strRepoName, strUserName, strPasswd);
            }
            this.log.logBasic("Connection successful to repository " + strRepoName);
            this.shell.dispose();
            if (this.getParent() != null && this.getParent().toString().equalsIgnoreCase("Shell {Repository Manager}")) {
                this.getParent().dispose();
            }
            return true;
        }
        catch (Exception e) {
            this.log.logError("Error connecting to repository ", (Throwable)e);
            this.messageBoxService("Repository connection unsuccessful. Please check logs.");
            this.lblFlag.setText(this.flagMessageBlank);
            this.loginBtn.setEnabled(true);
            return false;
        }
    }

    private void messageBoxService(String msgText) {
        MessageBox messageBox = new MessageBox(this.getParent().getShell(), 33);
        messageBox.setMessage(msgText);
        messageBox.open();
    }
}

