/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.dialog;

import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.json.simple.JSONObject;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.repo.dialog.BaseRepoFormComposite;

public class KettleFileRepoFormComposite
extends BaseRepoFormComposite {
    private Text txtLocation;
    private Button showHidden;
    private Button doNotModify;
    private static final Class<?> PKG = KettleFileRepoFormComposite.class;

    public KettleFileRepoFormComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Control uiAfterDisplayName() {
        PropsUI props = PropsUI.getInstance();
        Label lLoc = new Label((Composite)this, 0);
        lLoc.setText(BaseMessages.getString(PKG, (String)"repositories.location.label", (String[])new String[0]));
        lLoc.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top((Control)this.txtDisplayName, 15).result());
        props.setLook((Control)lLoc);
        this.txtLocation = new Text((Composite)this, 2048);
        this.txtLocation.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)lLoc, 5).width(300).result());
        this.txtLocation.addModifyListener(this.lsMod);
        props.setLook((Control)this.txtLocation);
        Button browseBtn = new Button((Composite)this, 8);
        browseBtn.setText(BaseMessages.getString(PKG, (String)"repositories.browse.label", (String[])new String[0]));
        browseBtn.setLayoutData((Object)new FormDataBuilder().left((Control)this.txtLocation, 5).top((Control)lLoc, 5).result());
        props.setLook((Control)browseBtn);
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog dialog = new DirectoryDialog(KettleFileRepoFormComposite.this.getShell());
                dialog.setFilterPath("c:\\");
                String selectedDir = dialog.open();
                if (!Utils.isEmpty((CharSequence)selectedDir)) {
                    KettleFileRepoFormComposite.this.txtLocation.setText(selectedDir);
                } else {
                    KettleFileRepoFormComposite.this.messageBoxService(BaseMessages.getString((Class)PKG, (String)"repositories.selectadirectory.label", (String[])new String[0]));
                }
            }
        });
        this.doNotModify = new Button((Composite)this, 32);
        this.doNotModify.setText(BaseMessages.getString(PKG, (String)"repositories.donotmodify.label", (String[])new String[0]));
        this.doNotModify.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)this.txtLocation, 15).result());
        props.setLook((Control)this.doNotModify);
        this.doNotModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KettleFileRepoFormComposite.this.lsMod.modifyText(null);
            }
        });
        this.showHidden = new Button((Composite)this, 32);
        this.showHidden.setText(BaseMessages.getString(PKG, (String)"repositories.showhidden.label", (String[])new String[0]));
        this.showHidden.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)this.doNotModify, 15).result());
        props.setLook((Control)this.showHidden);
        this.showHidden.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KettleFileRepoFormComposite.this.lsMod.modifyText(null);
            }
        });
        return this.showHidden;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> ret = super.toMap();
        ret.put("id", "KettleFileRepository");
        ret.put("location", this.txtLocation.getText());
        ret.put("showHiddenFolders", this.showHidden.getSelection());
        ret.put("doNotModify", this.doNotModify.getSelection());
        return ret;
    }

    @Override
    public void populate(JSONObject source) {
        super.populate(source);
        this.txtLocation.setText((String)source.getOrDefault((Object)"location", (Object)""));
        this.showHidden.setSelection(((Boolean)source.getOrDefault((Object)"showHiddenFolders", (Object)false)).booleanValue());
        this.doNotModify.setSelection(((Boolean)source.getOrDefault((Object)"doNotModify", (Object)false)).booleanValue());
    }

    @Override
    protected boolean validateSaveAllowed() {
        return super.validateSaveAllowed() && !Utils.isEmpty((CharSequence)this.txtLocation.getText());
    }

    private void messageBoxService(String msgText) {
        MessageBox messageBox = new MessageBox(this.getParent().getShell(), 33);
        messageBox.setMessage(msgText);
        messageBox.open();
    }
}

