/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogUtil {
    public static void addAppender(Appender appender, Logger logger, Level level) {
        LogUtil.addAppender(appender, logger, level, null);
    }

    public static void addAppender(Appender appender, Logger logger, Level level, Filter filter) {
        LoggerConfig loggerConfig;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        appender.start();
        config.addAppender(appender);
        LoggerConfig specificConfig = loggerConfig = config.getLoggerConfig(logger.getName());
        if (!loggerConfig.getName().equals(logger.getName())) {
            specificConfig = new LoggerConfig(logger.getName(), null, true);
            specificConfig.setParent(loggerConfig);
            config.addLogger(logger.getName(), specificConfig);
        }
        specificConfig.addAppender(appender, level, filter);
        ctx.updateLoggers();
    }

    public static void removeAppender(Appender appender, Logger logger) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        loggerConfig.removeAppender(appender.getName());
        ctx.updateLoggers();
        appender.stop();
    }

    public static Appender makeAppender(String name, StringWriter sw, String layout) {
        return ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName(name)).setLayout((Layout)PatternLayout.newBuilder().withPattern(layout).build())).setTarget((Writer)sw).build();
    }

    public static Appender makeAppender(String name, Writer writer, Layout layout) {
        return ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName(name)).setLayout(layout)).setTarget(writer).build();
    }

    public static Appender makeAppender(String name, Writer writer, Filter filter, Layout layout) {
        return ((WriterAppender.Builder)((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName(name)).setFilter(filter)).setLayout(layout)).setTarget(writer).build();
    }

    public static void setLevel(Logger logger, Level level) {
        Configurator.setLevel((String)logger.getName(), (Level)level);
    }

    public static void setRootLoggerLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static boolean exists(String logger) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        return config.getLoggers().keySet().contains(logger);
    }

    public static boolean isAttached(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        return loggerConfig.getAppenders().containsKey(appender.getName());
    }

    public static Map<String, Appender> getAppenders(Logger logger) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        return loggerConfig.getAppenders();
    }
}

