/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.parser;

import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.MCLParser;

public class TupleLineParser
extends MCLParser {
    public TupleLineParser(int columncount) {
        super(columncount);
    }

    @Override
    public int parse(String source) throws MCLParseException {
        int len = source.length();
        char[] chrLine = new char[len];
        source.getChars(0, len, chrLine, 0);
        if (chrLine[0] == '=') {
            if (this.values.length != 1) {
                throw new MCLParseException(this.values.length + " columns expected, but only single value found");
            }
            this.values[0] = source.substring(1);
            this.reset();
            return 0;
        }
        boolean inString = false;
        boolean escaped = false;
        int cursor = 2;
        int column = 0;
        StringBuilder uesc = new StringBuilder();
        block14: for (int i = 2; i < len; ++i) {
            switch (chrLine[i]) {
                default: {
                    escaped = false;
                    continue block14;
                }
                case '\\': {
                    escaped = !escaped;
                    continue block14;
                }
                case '\"': {
                    if (!inString) {
                        inString = true;
                    } else if (!escaped) {
                        inString = false;
                    }
                    escaped = false;
                    continue block14;
                }
                case '\t': {
                    if (!inString && i > 0 && chrLine[i - 1] == ',' || i + 1 == len - 1 && chrLine[++i] == ']') {
                        if (chrLine[cursor] == '\"' && chrLine[i - 2] == '\"') {
                            uesc.delete(0, uesc.length());
                            uesc.ensureCapacity(i - 2 - (cursor + 1));
                            for (int pos = cursor + 1; pos < i - 2; ++pos) {
                                if (chrLine[pos] == '\\' && pos + 1 < i - 2) {
                                    switch (chrLine[++pos]) {
                                        case '\\': {
                                            uesc.append('\\');
                                            break;
                                        }
                                        case 'n': {
                                            uesc.append('\n');
                                            break;
                                        }
                                        case 't': {
                                            uesc.append('\t');
                                            break;
                                        }
                                        case '\"': {
                                            uesc.append('\"');
                                            break;
                                        }
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': {
                                            if (pos + 2 < i - 2 && chrLine[pos + 1] >= '0' && chrLine[pos + 1] <= '7' && chrLine[pos + 2] >= '0' && chrLine[pos + 2] <= '7') {
                                                try {
                                                    uesc.append((char)Integer.parseInt("" + chrLine[pos] + chrLine[pos + 1] + chrLine[pos + 2], 8));
                                                    pos += 2;
                                                    break;
                                                }
                                                catch (NumberFormatException e) {
                                                    throw new AssertionError((Object)"Flow error, should never try to parse non-number");
                                                }
                                            }
                                        }
                                        default: {
                                            uesc.append(chrLine[pos]);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                uesc.append(chrLine[pos]);
                            }
                            this.values[column++] = uesc.toString();
                        } else {
                            this.values[column++] = i - 1 - cursor == 4 && source.indexOf("NULL", cursor) == cursor ? null : source.substring(cursor, i - 1);
                        }
                        cursor = i + 1;
                    }
                    escaped = false;
                }
            }
        }
        if (column != this.values.length) {
            throw new MCLParseException("illegal result length: " + column + "\nlast read: " + (column > 0 ? this.values[column - 1] : "<none>"));
        }
        this.reset();
        return 0;
    }
}

