/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import nl.cwi.monetdb.jdbc.MonetDatabaseMetaData;
import nl.cwi.monetdb.jdbc.MonetPreparedStatement;
import nl.cwi.monetdb.jdbc.MonetSavepoint;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.jdbc.types.INET;
import nl.cwi.monetdb.jdbc.types.URL;
import nl.cwi.monetdb.mcl.MCLException;
import nl.cwi.monetdb.mcl.io.BufferedMCLReader;
import nl.cwi.monetdb.mcl.io.BufferedMCLWriter;
import nl.cwi.monetdb.mcl.net.MapiSocket;
import nl.cwi.monetdb.mcl.parser.HeaderLineParser;
import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.StartOfHeaderParser;

public class MonetConnection
extends MonetWrapper
implements Connection {
    private final String hostname;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final MapiSocket server;
    private final BufferedMCLReader in;
    private final BufferedMCLWriter out;
    private StartOfHeaderParser sohp = new StartOfHeaderParser();
    private boolean closed;
    private boolean autoCommit = true;
    private SQLWarning warnings = null;
    private Map<String, Class<?>> typeMap = new HashMap<String, Class<?>>(){
        {
            this.put("inet", INET.class);
            this.put("url", URL.class);
        }
    };
    private Map<Statement, ?> statements = new WeakHashMap();
    private int curReplySize = -1;
    String[] queryTempl;
    String[] commandTempl;
    static final int LANG_SQL = 0;
    static final int LANG_MAL = 3;
    static final int LANG_UNKNOWN = -1;
    final int lang;
    private final boolean blobIsBinary;
    private static final int DEF_FETCHSIZE = 250;
    private static int seqCounter = 0;
    private SendThread sendThread = null;

    MonetConnection(Properties props) throws SQLException, IllegalArgumentException {
        int port;
        this.hostname = props.getProperty("host");
        try {
            port = Integer.parseInt(props.getProperty("port"));
        }
        catch (NumberFormatException e) {
            port = 0;
        }
        this.port = port;
        this.database = props.getProperty("database");
        this.username = props.getProperty("user");
        this.password = props.getProperty("password");
        String language = props.getProperty("language");
        boolean debug = Boolean.valueOf(props.getProperty("debug"));
        String hash = props.getProperty("hash");
        this.blobIsBinary = Boolean.valueOf(props.getProperty("treat_blob_as_binary"));
        int sockTimeout = 0;
        try {
            sockTimeout = Integer.parseInt(props.getProperty("so_timeout"));
        }
        catch (NumberFormatException e) {
            sockTimeout = 0;
        }
        if (this.hostname == null || this.hostname.trim().equals("")) {
            throw new IllegalArgumentException("hostname should not be null or empty");
        }
        if (port == 0) {
            throw new IllegalArgumentException("port should not be 0");
        }
        if (this.username == null || this.username.trim().equals("")) {
            throw new IllegalArgumentException("user should not be null or empty");
        }
        if (this.password == null || this.password.trim().equals("")) {
            throw new IllegalArgumentException("password should not be null or empty");
        }
        if (language == null || language.trim().equals("")) {
            language = "sql";
            this.addWarning("No language given, defaulting to 'sql'", "M1M05");
        }
        this.queryTempl = new String[3];
        this.commandTempl = new String[3];
        this.server = new MapiSocket();
        if (hash != null) {
            this.server.setHash(hash);
        }
        if (this.database != null) {
            this.server.setDatabase(this.database);
        }
        this.server.setLanguage(language);
        if (debug) {
            try {
                String fname = props.getProperty("logfile", "monet_" + System.currentTimeMillis() + ".log");
                File f = new File(fname);
                int ext = fname.lastIndexOf(".");
                if (ext < 0) {
                    ext = fname.length();
                }
                String pre = fname.substring(0, ext);
                String suf = fname.substring(ext);
                int i = 1;
                while (f.exists()) {
                    f = new File(pre + "-" + i + suf);
                    ++i;
                }
                this.server.debug(f.getAbsolutePath());
            }
            catch (IOException ex) {
                throw new SQLException("Opening logfile failed: " + ex.getMessage(), "08M01");
            }
        }
        try {
            List<String> warnings = this.server.connect(this.hostname, port, this.username, this.password);
            for (String warning : warnings) {
                this.addWarning(warning, "01M02");
            }
            this.server.setSoTimeout(sockTimeout);
            this.in = this.server.getReader();
            this.out = this.server.getWriter();
            String error = this.in.waitForPrompt();
            if (error != null) {
                throw new SQLException(error.substring(6), "08001");
            }
        }
        catch (IOException e) {
            throw new SQLException("Unable to connect (" + this.hostname + ":" + port + "): " + e.getMessage(), "08006");
        }
        catch (MCLParseException e) {
            throw new SQLException(e.getMessage(), "08001");
        }
        catch (MCLException e) {
            String[] connex = e.getMessage().split("\n");
            SQLException sqle = new SQLException(connex[0], "08001", e);
            for (int i = 1; i < connex.length; ++i) {
                sqle.setNextException(new SQLException(connex[1], "08001"));
            }
            throw sqle;
        }
        this.lang = "sql".equals(language) ? 0 : ("mal".equals(language) ? 3 : -1);
        if (this.lang == 0) {
            this.queryTempl[0] = "s";
            this.queryTempl[1] = ";";
            this.queryTempl[2] = ";\n";
            this.commandTempl[0] = "X";
            this.commandTempl[1] = null;
            this.commandTempl[2] = "\nX";
        } else if (this.lang == 3) {
            this.queryTempl[0] = null;
            this.queryTempl[1] = ";\n";
            this.queryTempl[2] = ";\n";
            this.commandTempl[0] = null;
            this.commandTempl[1] = null;
            this.commandTempl[2] = null;
        }
        if (this.lang == 0) {
            this.setAutoCommit(true);
            Calendar cal = Calendar.getInstance();
            int offset = cal.get(15) + cal.get(16);
            String tz = (offset /= 60000) < 0 ? "-" : "+";
            tz = tz + (Math.abs(offset) / 60 < 10 ? "0" : "") + Math.abs(offset) / 60 + ":";
            offset -= offset / 60 * 60;
            tz = tz + (offset < 10 ? "0" : "") + offset;
            this.sendIndependentCommand("SET TIME ZONE INTERVAL '" + tz + "' HOUR TO MINUTE");
        }
        this.closed = false;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            for (Statement st : this.statements.keySet()) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            this.server.close();
            if (this.sendThread != null) {
                this.sendThread.shutdown();
                this.sendThread = null;
            }
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        try (ResponseList l = new ResponseList(0, 0, 1000, 1007);){
            l.processQuery("COMMIT");
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf(String, Object[]) not supported", "0A000");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            MonetStatement ret = new MonetStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.statements.put(ret, null);
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "M0M03");
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createClob() not supported", "0A000");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createBlob() not supported", "0A000");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob() not supported", "0A000");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct() not supported", "0A000");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML() not supported", "0A000");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        if (this.lang != 0) {
            throw new SQLException("This method is only supported in SQL mode", "M0M04");
        }
        try (ResultSet rs = this.getMetaData().getCatalogs();){
            String string = rs.next() ? rs.getString(1) : null;
            return string;
        }
    }

    @Override
    public String getClientInfo(String name) {
        return null;
    }

    @Override
    public Properties getClientInfo() {
        return new Properties();
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.lang != 0) {
            throw new SQLException("This method is only supported in SQL mode", "M0M04");
        }
        return new MonetDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() {
        return 8;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout is less than 0", "M1M05");
        }
        if (this.closed) {
            return false;
        }
        try {
            Statement stmt = this.createStatement();
            stmt.executeQuery("SELECT 1");
            stmt.close();
            return true;
        }
        catch (SQLException e) {
            this.close();
            return false;
        }
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            MonetPreparedStatement ret = new MonetPreparedStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, sql);
            this.statements.put(ret, null);
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint sp = (MonetSavepoint)savepoint;
        try (ResponseList l = new ResponseList(0, 0, 1000, 1007);){
            l.processQuery("RELEASE SAVEPOINT " + sp.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        try (ResponseList l = new ResponseList(0, 0, 1000, 1007);){
            l.processQuery("ROLLBACK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint sp = (MonetSavepoint)savepoint;
        try (ResponseList l = new ResponseList(0, 0, 1000, 1007);){
            l.processQuery("ROLLBACK TO SAVEPOINT " + sp.getName());
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit != autoCommit) {
            this.sendControlCommand("auto_commit " + (autoCommit ? "1" : "0"));
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.addWarning("clientInfo: " + name + "is not a recognised property", "01M07");
    }

    @Override
    public void setClientInfo(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.setClientInfo(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            this.addWarning("cannot setReadOnly(true): read-only Connection mode not supported", "01M08");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() throws SQLException {
        MonetSavepoint sp = new MonetSavepoint();
        try (ResponseList l = new ResponseList(0, 0, 1000, 1007);){
            l.processQuery("SAVEPOINT " + sp.getName());
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        MonetSavepoint sp;
        try {
            sp = new MonetSavepoint(name);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.getMessage(), "M0M03");
        }
        try (ResponseList l = new ResponseList(0, 0, 1000, 1007);){
            l.processQuery("SAVEPOINT " + sp.getName());
        }
        return sp;
    }

    @Override
    public void setTransactionIsolation(int level) {
        if (level != 8) {
            this.addWarning("MonetDB only supports fully serializable transactions, continuing with transaction level raised to TRANSACTION_SERIALIZABLE", "01M09");
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    public String toString() {
        return "MonetDB Connection (" + this.getJDBCURL() + ") " + (this.closed ? "connected" : "disconnected");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        this.createStatement().executeUpdate("SET SCHEMA = \"" + schema + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        try (ResultSet rs = this.createStatement().executeQuery("SELECT CURRENT_SCHEMA");){
            if (!rs.next()) {
                throw new SQLException("Row expected", "02000");
            }
            String string = rs.getString(1);
            return string;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            return;
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int millis) throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        if (millis < 0) {
            throw new SQLException("milliseconds is less than zero", "M1M05");
        }
        try {
            this.server.setSoTimeout(millis);
        }
        catch (SocketException e) {
            throw new SQLException(e.getMessage(), "08000");
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        try {
            return this.server.getSoTimeout();
        }
        catch (SocketException e) {
            throw new SQLException(e.getMessage(), "08000");
        }
    }

    public String getJDBCURL() {
        String language = "";
        if (this.lang == 3) {
            language = "?language=mal";
        }
        return "jdbc:monetdb://" + this.hostname + ":" + this.port + "/" + this.database + language;
    }

    boolean getBlobAsBinary() {
        return this.blobIsBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendIndependentCommand(String command) throws SQLException {
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            try {
                this.out.writeLine((this.queryTempl[0] == null ? "" : this.queryTempl[0]) + command + (this.queryTempl[1] == null ? "" : this.queryTempl[1]));
                String error = this.in.waitForPrompt();
                if (error != null) {
                    throw new SQLException(error.substring(6), error.substring(0, 5));
                }
            }
            catch (SocketTimeoutException e) {
                this.close();
                throw new SQLException("connection timed out", "08M33");
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage(), "08000");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendControlCommand(String command) throws SQLException {
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            try {
                this.out.writeLine((this.commandTempl[0] == null ? "" : this.commandTempl[0]) + command + (this.commandTempl[1] == null ? "" : this.commandTempl[1]));
                String error = this.in.waitForPrompt();
                if (error != null) {
                    throw new SQLException(error.substring(6), error.substring(0, 5));
                }
            }
            catch (SocketTimeoutException e) {
                this.close();
                throw new SQLException("connection timed out", "08M33");
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage(), "08000");
            }
        }
    }

    void addWarning(String reason, String sqlstate) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(reason, sqlstate);
        } else {
            this.warnings.setNextWarning(new SQLWarning(reason, sqlstate));
        }
    }

    static class SendThread
    extends Thread {
        private static final int WAIT = 0;
        private static final int QUERY = 1;
        private static final int SHUTDOWN = -1;
        private String[] templ;
        private String query;
        private BufferedMCLWriter out;
        private String error;
        private int state = 0;
        final Lock sendLock = new ReentrantLock();
        final Condition queryAvailable = this.sendLock.newCondition();
        final Condition waiting = this.sendLock.newCondition();

        public SendThread(BufferedMCLWriter out) {
            super("SendThread");
            this.setDaemon(true);
            this.out = out;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.sendLock.lock();
            try {
                while (true) {
                    if (this.state == 0) {
                        try {
                            this.queryAvailable.await();
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    if (this.state == -1) {
                        break;
                    }
                    try {
                        this.out.writeLine((this.templ[0] == null ? "" : this.templ[0]) + this.query + (this.templ[1] == null ? "" : this.templ[1]));
                    }
                    catch (IOException e) {
                        this.error = e.getMessage();
                    }
                    this.state = 0;
                    this.waiting.signal();
                }
            }
            finally {
                this.sendLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runQuery(String[] templ, String query) throws SQLException {
            this.sendLock.lock();
            try {
                if (this.state != 0) {
                    throw new SQLException("SendThread already in use or shutting down!", "M0M03");
                }
                this.templ = templ;
                this.query = query;
                this.state = 1;
                this.queryAvailable.signal();
            }
            finally {
                this.sendLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getErrors() {
            this.sendLock.lock();
            try {
                while (this.state == 1) {
                    try {
                        this.waiting.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.state == -1) {
                    this.error = "SendThread is shutting down";
                }
            }
            finally {
                this.sendLock.unlock();
            }
            return this.error;
        }

        public void shutdown() {
            this.sendLock.lock();
            this.state = -1;
            this.sendLock.unlock();
            this.interrupt();
        }
    }

    class ResponseList {
        final int cachesize;
        final int maxrows;
        final int rstype;
        final int rsconcur;
        final int seqnr;
        private List<Response> responses;
        private Map<Integer, ResultSetResponse> rsresponses;
        private int curResponse;

        ResponseList(int cachesize, int maxrows, int rstype, int rsconcur) throws SQLException {
            this.cachesize = cachesize;
            this.maxrows = maxrows;
            this.rstype = rstype;
            this.rsconcur = rsconcur;
            this.responses = new ArrayList<Response>();
            this.curResponse = -1;
            this.seqnr = seqCounter++;
        }

        Response getNextResponse() throws SQLException {
            if (this.rstype == 1003 && this.curResponse >= 0 && this.curResponse < this.responses.size()) {
                Response tmp = this.responses.get(this.curResponse);
                if (tmp != null) {
                    tmp.close();
                }
                this.responses.set(this.curResponse, null);
            }
            ++this.curResponse;
            if (this.curResponse >= this.responses.size()) {
                return null;
            }
            return this.responses.get(this.curResponse);
        }

        void closeResponse(int i) {
            if (i < 0 || i >= this.responses.size()) {
                return;
            }
            Response tmp = this.responses.set(i, null);
            if (tmp != null) {
                tmp.close();
            }
        }

        void closeCurrentResponse() {
            this.closeResponse(this.curResponse);
        }

        void closeCurOldResponses() {
            for (int i = this.curResponse; i >= 0; --i) {
                this.closeResponse(i);
            }
        }

        void close() {
            for (int i = 0; i < this.responses.size(); ++i) {
                this.closeResponse(i);
            }
        }

        boolean hasUnclosedResponses() {
            for (Response r : this.responses) {
                if (r == null) continue;
                return true;
            }
            return false;
        }

        void processQuery(String query) throws SQLException {
            this.executeQuery(MonetConnection.this.queryTempl, query);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeQuery(String[] templ, String query) throws SQLException {
            boolean sendThreadInUse = false;
            String error = null;
            try {
                String tmp;
                MapiSocket mapiSocket = MonetConnection.this.server;
                synchronized (mapiSocket) {
                    MonetConnection.this.in.waitForPrompt();
                    int size = this.cachesize == 0 ? 250 : this.cachesize;
                    int n = size = this.maxrows != 0 ? Math.min(this.maxrows, size) : size;
                    if (MonetConnection.this.lang == 0 && size != MonetConnection.this.curReplySize && templ != MonetConnection.this.commandTempl) {
                        MonetConnection.this.sendControlCommand("reply_size " + size);
                        MonetConnection.this.curReplySize = size;
                    }
                    if (query.length() > 8190) {
                        if (MonetConnection.this.sendThread == null) {
                            MonetConnection.this.sendThread = new SendThread(MonetConnection.this.out);
                        }
                        MonetConnection.this.sendThread.runQuery(templ, query);
                        sendThreadInUse = true;
                    } else {
                        MonetConnection.this.out.writeLine((templ[0] == null ? "" : templ[0]) + query + (templ[1] == null ? "" : templ[1]));
                    }
                    String tmpLine = MonetConnection.this.in.readLine();
                    int linetype = MonetConnection.this.in.getLineType();
                    Response res = null;
                    block21: while (linetype != 46) {
                        switch (linetype) {
                            case 38: {
                                try {
                                    switch (MonetConnection.this.sohp.parse(tmpLine)) {
                                        case 48: {
                                            throw new MCLParseException("Q_PARSE header not allowed here", 1);
                                        }
                                        case 49: 
                                        case 53: {
                                            int id = MonetConnection.this.sohp.getNextAsInt();
                                            int tuplecount = MonetConnection.this.sohp.getNextAsInt();
                                            int columncount = MonetConnection.this.sohp.getNextAsInt();
                                            int rowcount = MonetConnection.this.sohp.getNextAsInt();
                                            if (this.maxrows != 0 && tuplecount > this.maxrows) {
                                                tuplecount = this.maxrows;
                                            }
                                            res = new ResultSetResponse(id, tuplecount, columncount, rowcount, this, this.seqnr);
                                            if (rowcount < tuplecount) {
                                                if (this.rsresponses == null) {
                                                    this.rsresponses = new HashMap<Integer, ResultSetResponse>();
                                                }
                                                this.rsresponses.put(id, (ResultSetResponse)res);
                                            }
                                            break;
                                        }
                                        case 50: {
                                            res = new UpdateResponse(MonetConnection.this.sohp.getNextAsInt(), MonetConnection.this.sohp.getNextAsString());
                                            break;
                                        }
                                        case 51: {
                                            res = new SchemaResponse();
                                            break;
                                        }
                                        case 52: {
                                            boolean ac;
                                            boolean bl = ac = MonetConnection.this.sohp.getNextAsString().equals("t");
                                            if (MonetConnection.this.autoCommit && ac) {
                                                MonetConnection.this.addWarning("Server enabled auto commit mode while local state already was auto commit.", "01M11");
                                            }
                                            MonetConnection.this.autoCommit = ac;
                                            res = new AutoCommitResponse(ac);
                                            break;
                                        }
                                        case 54: {
                                            int id = MonetConnection.this.sohp.getNextAsInt();
                                            MonetConnection.this.sohp.getNextAsInt();
                                            int rowcount = MonetConnection.this.sohp.getNextAsInt();
                                            int offset = MonetConnection.this.sohp.getNextAsInt();
                                            ResultSetResponse t = this.rsresponses.get(id);
                                            if (t == null) {
                                                error = "M0M12!no ResultSetResponse with id " + id + " found";
                                                break;
                                            }
                                            DataBlockResponse r = new DataBlockResponse(rowcount, t.getRSType() == 1003);
                                            t.addDataBlockResponse(offset, r);
                                            res = r;
                                        }
                                    }
                                }
                                catch (MCLParseException e) {
                                    error = "M0M10!error while parsing start of header:\n" + e.getMessage() + " found: '" + tmpLine.charAt(e.getErrorOffset()) + "'" + " in: \"" + tmpLine + "\"" + " at pos: " + e.getErrorOffset();
                                    MonetConnection.this.in.waitForPrompt();
                                    linetype = MonetConnection.this.in.getLineType();
                                    continue block21;
                                }
                                if (error != null) {
                                    MonetConnection.this.in.waitForPrompt();
                                    linetype = MonetConnection.this.in.getLineType();
                                    continue block21;
                                }
                                while (res.wantsMore()) {
                                    error = res.addLine(MonetConnection.this.in.readLine(), MonetConnection.this.in.getLineType());
                                    if (error == null) continue;
                                    error = "M0M10!" + error;
                                    MonetConnection.this.in.waitForPrompt();
                                    linetype = MonetConnection.this.in.getLineType();
                                    break;
                                }
                                if (error != null) continue block21;
                                if (!(res instanceof DataBlockResponse)) {
                                    this.responses.add(res);
                                }
                                tmpLine = MonetConnection.this.in.readLine();
                                linetype = MonetConnection.this.in.getLineType();
                                continue block21;
                            }
                            case 35: {
                                MonetConnection.this.addWarning(tmpLine.substring(1), "01000");
                                tmpLine = MonetConnection.this.in.readLine();
                                linetype = MonetConnection.this.in.getLineType();
                                continue block21;
                            }
                            default: {
                                tmpLine = "!M0M10!protocol violation, unexpected line: " + tmpLine;
                            }
                            case 33: 
                        }
                        error = MonetConnection.this.in.waitForPrompt();
                        linetype = MonetConnection.this.in.getLineType();
                        if (error != null) {
                            error = tmpLine.substring(1) + "\n" + error;
                            continue;
                        }
                        error = tmpLine.substring(1);
                    }
                }
                if (sendThreadInUse && (tmp = MonetConnection.this.sendThread.getErrors()) != null) {
                    error = error == null ? "08000!" + tmp : error + "\n08000!" + tmp;
                }
                if (error != null) {
                    SQLException ret = null;
                    String[] errors = error.split("\n");
                    for (int i = 0; i < errors.length; ++i) {
                        if (ret == null) {
                            ret = new SQLException(errors[i].substring(6), errors[i].substring(0, 5));
                            continue;
                        }
                        ret.setNextException(new SQLException(errors[i].substring(6), errors[i].substring(0, 5)));
                    }
                    throw ret;
                }
            }
            catch (SocketTimeoutException e) {
                this.close();
                throw new SQLException("connection timed out", "08M33");
            }
            catch (IOException e) {
                MonetConnection.this.closed = true;
                throw new SQLException(e.getMessage() + " (mserver still alive?)", "08000");
            }
        }
    }

    class AutoCommitResponse
    extends SchemaResponse {
        public final boolean autocommit;

        public AutoCommitResponse(boolean ac) {
            this.autocommit = ac;
        }
    }

    class SchemaResponse
    implements Response {
        public final int state = -2;

        SchemaResponse() {
        }

        @Override
        public String addLine(String line, int linetype) {
            return "Header lines are not supported for a SchemaResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void complete() {
        }

        @Override
        public void close() {
        }
    }

    static class UpdateResponse
    implements Response {
        public final int count;
        public final String lastid;

        public UpdateResponse(int cnt, String id) {
            this.count = cnt;
            this.lastid = id;
        }

        @Override
        public String addLine(String line, int linetype) {
            return "Header lines are not supported for an UpdateResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void complete() {
        }

        @Override
        public void close() {
        }
    }

    static class DataBlockResponse
    implements Response {
        private final String[] data;
        private int pos = -1;
        private boolean forwardOnly;

        DataBlockResponse(int size, boolean forward) {
            this.data = new String[size];
            this.forwardOnly = forward;
        }

        @Override
        public String addLine(String line, int linetype) {
            if (linetype != 91) {
                return "protocol violation: unexpected line in data block: " + line;
            }
            this.data[++this.pos] = line;
            return null;
        }

        @Override
        public boolean wantsMore() {
            return this.pos + 1 < this.data.length;
        }

        @Override
        public void complete() throws SQLException {
            if (this.pos + 1 != this.data.length) {
                throw new SQLException("Inconsistent state detected!  Current block capacity: " + this.data.length + ", block usage: " + (this.pos + 1) + ".  Did MonetDB send what it promised to?", "M0M10");
            }
        }

        @Override
        public void close() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = null;
            }
        }

        String getRow(int line) {
            if (this.forwardOnly) {
                String ret = this.data[line];
                this.data[line] = null;
                return ret;
            }
            return this.data[line];
        }
    }

    class ResultSetResponse
    implements Response {
        public final int columncount;
        public final int tuplecount;
        private int cacheSize;
        public final int id;
        private String[] name;
        private String[] type;
        private int[] columnLengths;
        private String[] tableNames;
        private final int seqnr;
        private DataBlockResponse[] resultBlocks;
        private boolean[] isSet = new boolean[7];
        private boolean closed;
        private ResponseList parent;
        private boolean cacheSizeSetExplicitly = false;
        private boolean destroyOnClose;
        private int blockOffset = 0;
        HeaderLineParser hlp;
        private static final int NAMES = 0;
        private static final int TYPES = 1;
        private static final int TABLES = 2;
        private static final int LENS = 3;

        ResultSetResponse(int id, int tuplecount, int columncount, int rowcount, ResponseList parent, int seq) throws SQLException {
            this.parent = parent;
            if (parent.cachesize == 0) {
                this.cacheSize = 250;
                this.cacheSizeSetExplicitly = false;
            } else {
                this.cacheSize = parent.cachesize;
                this.cacheSizeSetExplicitly = true;
            }
            if (rowcount > this.cacheSize) {
                this.cacheSize = rowcount;
            }
            this.seqnr = seq;
            this.closed = false;
            this.destroyOnClose = false;
            this.id = id;
            this.tuplecount = tuplecount;
            this.columncount = columncount;
            this.resultBlocks = new DataBlockResponse[tuplecount / this.cacheSize + 1];
            this.hlp = new HeaderLineParser(columncount);
            this.resultBlocks[0] = new DataBlockResponse(rowcount, parent.rstype == 1003);
        }

        @Override
        public String addLine(String tmpLine, int linetype) {
            if (this.isSet[3] && this.isSet[1] && this.isSet[2] && this.isSet[0]) {
                return this.resultBlocks[0].addLine(tmpLine, linetype);
            }
            if (linetype != 37) {
                return "header expected, got: " + tmpLine;
            }
            try {
                switch (this.hlp.parse(tmpLine)) {
                    case 1: {
                        this.name = (String[])this.hlp.values.clone();
                        this.isSet[0] = true;
                        break;
                    }
                    case 2: {
                        this.columnLengths = (int[])this.hlp.intValues.clone();
                        this.isSet[3] = true;
                        break;
                    }
                    case 4: {
                        this.type = (String[])this.hlp.values.clone();
                        this.isSet[1] = true;
                        break;
                    }
                    case 3: {
                        this.tableNames = (String[])this.hlp.values.clone();
                        this.isSet[2] = true;
                    }
                }
            }
            catch (MCLParseException e) {
                return e.getMessage();
            }
            return null;
        }

        @Override
        public boolean wantsMore() {
            if (this.isSet[3] && this.isSet[1] && this.isSet[2] && this.isSet[0]) {
                return this.resultBlocks[0].wantsMore();
            }
            return true;
        }

        private final String[] getValues(char[] chrLine, int start, int stop) {
            int elem = 0;
            String[] values = new String[this.columncount];
            for (int i = start; i < stop; ++i) {
                if (chrLine[i] != '\t' || chrLine[i - 1] != ',') continue;
                values[elem++] = new String(chrLine, start, i - 1 - start);
                start = i + 1;
            }
            values[elem++] = new String(chrLine, start, stop - start);
            return values;
        }

        void addDataBlockResponse(int offset, DataBlockResponse rr) {
            int block = (offset - this.blockOffset) / this.cacheSize;
            this.resultBlocks[block] = rr;
        }

        @Override
        public void complete() throws SQLException {
            String error = "";
            if (!this.isSet[0]) {
                error = error + "name header missing\n";
            }
            if (!this.isSet[1]) {
                error = error + "type header missing\n";
            }
            if (!this.isSet[2]) {
                error = error + "table name header missing\n";
            }
            if (!this.isSet[3]) {
                error = error + "column width header missing\n";
            }
            if (error != "") {
                throw new SQLException(error, "M0M10");
            }
        }

        String[] getNames() {
            return this.name;
        }

        String[] getTypes() {
            return this.type;
        }

        String[] getTableNames() {
            return this.tableNames;
        }

        int[] getColumnLengths() {
            return this.columnLengths;
        }

        int getCacheSize() {
            return this.cacheSize;
        }

        int getBlockOffset() {
            return this.blockOffset;
        }

        int getRSType() {
            return this.parent.rstype;
        }

        int getRSConcur() {
            return this.parent.rsconcur;
        }

        String getLine(int row) throws SQLException {
            if (row >= this.tuplecount || row < 0) {
                return null;
            }
            int block = (row - this.blockOffset) / this.cacheSize;
            int blockLine = (row - this.blockOffset) % this.cacheSize;
            DataBlockResponse rawr = this.resultBlocks[block];
            if (rawr == null) {
                if (this.parent.rstype == 1003) {
                    for (int i = 0; i < block; ++i) {
                        this.resultBlocks[i] = null;
                    }
                    if (seqCounter - 1 == this.seqnr && !this.cacheSizeSetExplicitly && this.tuplecount - row > this.cacheSize && this.cacheSize < 2500) {
                        this.blockOffset += this.cacheSize;
                        this.cacheSize *= 10;
                        block = (row - this.blockOffset) / this.cacheSize;
                        blockLine = (row - this.blockOffset) % this.cacheSize;
                    }
                }
                this.parent.executeQuery(MonetConnection.this.commandTempl, "export " + this.id + " " + (block * this.cacheSize + this.blockOffset) + " " + this.cacheSize);
                rawr = this.resultBlocks[block];
                if (rawr == null) {
                    throw new AssertionError((Object)("block " + block + " should have been fetched by now :("));
                }
            }
            return rawr.getRow(blockLine);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                if (this.destroyOnClose) {
                    MonetConnection.this.sendControlCommand("close " + this.id);
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            for (int i = 1; i < this.resultBlocks.length; ++i) {
                DataBlockResponse r = this.resultBlocks[i];
                if (r == null) continue;
                r.close();
            }
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    static interface Response {
        public String addLine(String var1, int var2);

        public boolean wantsMore();

        public void complete() throws SQLException;

        public void close();
    }
}

