/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.serializers.MarshalException;

public class TypeUtil {
    public static boolean isValid(ByteBuffer term, AbstractType<?> validator) {
        try {
            validator.validate(term);
            return true;
        }
        catch (MarshalException e) {
            return false;
        }
    }

    public static ByteBuffer tryUpcast(ByteBuffer term, AbstractType<?> validator) {
        if (term.remaining() == 0) {
            return null;
        }
        try {
            if (validator instanceof Int32Type && term.remaining() == 2) {
                return Int32Type.instance.decompose(Integer.valueOf(term.getShort(term.position())));
            }
            if (validator instanceof LongType) {
                long upcastToken;
                switch (term.remaining()) {
                    case 2: {
                        upcastToken = term.getShort(term.position());
                        break;
                    }
                    case 4: {
                        upcastToken = ((Integer)Int32Type.instance.compose(term)).intValue();
                        break;
                    }
                    default: {
                        upcastToken = Long.parseLong(UTF8Type.instance.getString(term));
                    }
                }
                return LongType.instance.decompose(upcastToken);
            }
            if (validator instanceof DoubleType && term.remaining() == 4) {
                return DoubleType.instance.decompose(Double.valueOf(((Float)FloatType.instance.compose(term)).floatValue()));
            }
            return validator.fromString(UTF8Type.instance.getString(term));
        }
        catch (Exception e) {
            return null;
        }
    }
}

