/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.api.reporting;

import java.io.Serializable;

public class Metrics
implements Serializable {
    private static final long serialVersionUID = -5354823227842967351L;
    private final long in;
    private final long out;
    private final long dropped;
    private final long inFlight;

    public static Metrics empty() {
        return new Metrics(0L, 0L, 0L, 0L);
    }

    public Metrics(long in, long out, long dropped, long inFlight) {
        this.in = in;
        this.out = out;
        this.dropped = dropped;
        this.inFlight = inFlight;
    }

    public long getIn() {
        return this.in;
    }

    public long getOut() {
        return this.out;
    }

    public long getDropped() {
        return this.dropped;
    }

    public long getInFlight() {
        return this.inFlight;
    }

    public String toString() {
        return String.format("Metrics{in=%d, out=%d, dropped=%d, inFlight=%d}", this.in, this.out, this.dropped, this.inFlight);
    }

    public Metrics add(Metrics right) {
        return new Metrics(this.getIn() + right.getIn(), this.getOut() + right.getOut(), this.getDropped() + right.getDropped(), this.getInFlight() + right.getInFlight());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics metrics = (Metrics)o;
        if (this.in != metrics.in) {
            return false;
        }
        if (this.out != metrics.out) {
            return false;
        }
        if (this.dropped != metrics.dropped) {
            return false;
        }
        return this.inFlight == metrics.inFlight;
    }

    public int hashCode() {
        int result = (int)(this.in ^ this.in >>> 32);
        result = 31 * result + (int)(this.out ^ this.out >>> 32);
        result = 31 * result + (int)(this.dropped ^ this.dropped >>> 32);
        result = 31 * result + (int)(this.inFlight ^ this.inFlight >>> 32);
        return result;
    }
}

