/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.api.reporting;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.engine.api.reporting.LogLevel;

public class LogEntry
implements Serializable {
    private static final long serialVersionUID = 5399802987623128546L;
    private String message;
    private LogLevel logLogLevel;
    private Map<String, String> extras;
    private Throwable throwable;
    private Date timestamp;

    protected LogEntry() {
    }

    public String getMessage() {
        return this.message;
    }

    public LogLevel getLogLogLevel() {
        return this.logLogLevel;
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntry logEntry = (LogEntry)o;
        if (this.logLogLevel != logEntry.logLogLevel) {
            return false;
        }
        if (this.extras != null ? !this.extras.equals(logEntry.extras) : logEntry.extras != null) {
            return false;
        }
        return this.timestamp.equals(logEntry.timestamp);
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + this.logLogLevel.hashCode();
        result = 31 * result + (this.extras != null ? this.extras.hashCode() : 0);
        result = 31 * result + this.timestamp.hashCode();
        return result;
    }

    public static final class LogEntryBuilder {
        private static long serialVersionUID = 5399802987623128546L;
        private String message;
        private LogLevel logLogLevel;
        private Map<String, String> extras = new HashMap<String, String>();
        private Throwable throwable;
        private Date timestamp;

        public static LogEntryBuilder aLogEntry() {
            return new LogEntryBuilder();
        }

        public LogEntryBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public LogEntryBuilder withLogLevel(LogLevel logLogLevel) {
            this.logLogLevel = logLogLevel;
            return this;
        }

        public LogEntryBuilder withExtras(Map<String, String> extras) {
            this.extras.putAll(extras);
            return this;
        }

        public LogEntryBuilder withThrowable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public LogEntryBuilder withTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public LogEntry build() {
            LogEntry logEntry = new LogEntry();
            logEntry.logLogLevel = this.logLogLevel;
            logEntry.message = this.message;
            logEntry.timestamp = this.timestamp;
            logEntry.extras = this.extras;
            logEntry.throwable = this.throwable;
            return logEntry;
        }
    }
}

