/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.johnzon.core.ThreadLocalBufferCache;

public enum BufferStrategy {
    BY_INSTANCE{

        @Override
        public BufferProvider<char[]> newCharProvider(int size) {
            return new CharBufferByInstanceProvider(size);
        }

        @Override
        public BufferProvider<StringBuilder> newStringBuilderProvider(int size) {
            return new StringBuilderByInstanceProvider(size);
        }
    }
    ,
    THREAD_LOCAL{

        @Override
        public BufferProvider<char[]> newCharProvider(int size) {
            return new CharBufferThreadLocalProvider(size);
        }

        @Override
        public BufferProvider<StringBuilder> newStringBuilderProvider(int size) {
            return new StringBuilderThreadLocalProvider(size);
        }
    }
    ,
    QUEUE{

        @Override
        public BufferProvider<char[]> newCharProvider(int size) {
            return new CharBufferQueueProvider(size);
        }

        @Override
        public BufferProvider<StringBuilder> newStringBuilderProvider(int size) {
            return new StringBuilderQueueProvider(size);
        }
    }
    ,
    SINGLETON{

        @Override
        public BufferProvider<char[]> newCharProvider(int size) {
            return new CharBufferSingletonProvider(size);
        }

        @Override
        public BufferProvider<StringBuilder> newStringBuilderProvider(int size) {
            return new StringBuilderSingletonProvider(size);
        }
    };


    public abstract BufferProvider<char[]> newCharProvider(int var1);

    public abstract BufferProvider<StringBuilder> newStringBuilderProvider(int var1);

    private static class StringBuilderQueueProvider
    extends QueueProvider<StringBuilder> {
        public StringBuilderQueueProvider(int size) {
            super(size);
        }

        @Override
        protected StringBuilder newInstance(int size) {
            return new StringBuilder(size);
        }

        @Override
        public void release(StringBuilder value) {
            value.setLength(0);
            super.release(value);
        }
    }

    private static class CharBufferQueueProvider
    extends QueueProvider<char[]> {
        public CharBufferQueueProvider(int size) {
            super(size);
        }

        @Override
        protected char[] newInstance(int size) {
            return new char[size];
        }
    }

    private static abstract class QueueProvider<T>
    implements BufferProvider<T> {
        private final int size;
        private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();

        public QueueProvider(int size) {
            this.size = size;
        }

        protected abstract T newInstance(int var1);

        @Override
        public T newBuffer() {
            T buffer = this.queue.poll();
            if (buffer == null) {
                return this.newInstance(this.size);
            }
            return buffer;
        }

        @Override
        public void release(T value) {
            this.queue.offer(value);
        }
    }

    private static class StringBuilderByInstanceProvider
    implements BufferProvider<StringBuilder> {
        private final int size;

        public StringBuilderByInstanceProvider(int size) {
            this.size = size;
        }

        @Override
        public StringBuilder newBuffer() {
            return new StringBuilder(this.size);
        }

        @Override
        public void release(StringBuilder value) {
        }
    }

    private static class CharBufferByInstanceProvider
    implements BufferProvider<char[]> {
        private final int size;

        public CharBufferByInstanceProvider(int size) {
            this.size = size;
        }

        @Override
        public char[] newBuffer() {
            return new char[this.size];
        }

        @Override
        public void release(char[] value) {
        }
    }

    private static class StringBuilderThreadLocalProvider
    extends ThreadLocalProvider<StringBuilder> {
        public StringBuilderThreadLocalProvider(int size) {
            super(size);
        }

        @Override
        protected StringBuilder newInstance(int size) {
            return new StringBuilder(size);
        }

        @Override
        public void release(StringBuilder value) {
            value.setLength(0);
            super.release(value);
        }
    }

    private static class CharBufferThreadLocalProvider
    extends ThreadLocalProvider<char[]> {
        public CharBufferThreadLocalProvider(int size) {
            super(size);
        }

        @Override
        protected char[] newInstance(int size) {
            return new char[size];
        }
    }

    private static abstract class ThreadLocalProvider<T>
    implements BufferProvider<T> {
        private final ThreadLocalBufferCache<T> cache;

        public ThreadLocalProvider(final int size) {
            this.cache = new ThreadLocalBufferCache<T>(size){

                @Override
                protected T newValue(int defaultSize) {
                    return ThreadLocalProvider.this.newInstance(size);
                }
            };
        }

        protected abstract T newInstance(int var1);

        @Override
        public T newBuffer() {
            return this.cache.getCache();
        }

        @Override
        public void release(T value) {
            this.cache.release(value);
        }
    }

    private static abstract class SingletonProvider<T>
    implements BufferProvider<T> {
        protected final T buffer;

        public SingletonProvider(int size) {
            this.buffer = this.newInstance(size);
        }

        protected abstract T newInstance(int var1);

        @Override
        public T newBuffer() {
            return this.buffer;
        }

        @Override
        public void release(T value) {
        }
    }

    private static class StringBuilderSingletonProvider
    extends SingletonProvider<StringBuilder> {
        public StringBuilderSingletonProvider(int size) {
            super(size);
        }

        @Override
        protected StringBuilder newInstance(int size) {
            return new StringBuilder(size);
        }

        @Override
        public void release(StringBuilder value) {
            value.setLength(0);
        }
    }

    private static class CharBufferSingletonProvider
    extends SingletonProvider<char[]> {
        public CharBufferSingletonProvider(int size) {
            super(size);
        }

        @Override
        protected char[] newInstance(int size) {
            return new char[size];
        }

        @Override
        public void release(char[] value) {
        }
    }

    public static interface BufferProvider<T>
    extends Serializable {
        public T newBuffer();

        public void release(T var1);
    }
}

